/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslContext;
import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PgDecoder
extends ByteToMessageDecoder {
    private static final Logger LOGGER = LogManager.getLogger(PgDecoder.class);
    static final int CANCEL_REQUEST_CODE = 80877102;
    static final int SSL_REQUEST_CODE = 80877103;
    static final int PROTOCOL_VERSION_REQUEST_CODE = 196608;
    static final int MIN_STARTUP_LENGTH = 8;
    static final int MIN_MSG_LENGTH = 5;
    static final int MAX_STARTUP_LENGTH = 10000;
    private final Supplier<SslContext> getSslContext;
    private State state;
    private byte msgType;
    private int payloadLength;

    public PgDecoder(Supplier<SslContext> getSslContext) {
        this.setCumulator(COMPOSITE_CUMULATOR);
        this.state = State.STARTUP;
        this.getSslContext = getSslContext;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        ByteBuf decode = this.decode(ctx, in);
        if (decode != null) {
            out.add(decode);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        super.channelRead(ctx, msg);
    }

    private ByteBuf decode(ChannelHandlerContext ctx, ByteBuf in) {
        switch (this.state.ordinal()) {
            case 0: {
                LOGGER.trace("Readable bytes: {}", (Object)in.readableBytes());
                if (in.readableBytes() == 0) {
                    Channel channel = ctx.channel();
                    ByteBuf out = ctx.alloc().buffer(1);
                    channel.writeAndFlush((Object)out.writeByte(48));
                    return null;
                }
                in.markReaderIndex();
                this.payloadLength = in.readInt();
                if (this.payloadLength < 8 || this.payloadLength > 10000) {
                    in.skipBytes(in.readableBytes());
                    throw new IllegalStateException("invalid length of startup packet");
                }
                this.payloadLength -= 8;
                int requestCode = in.readInt();
                LOGGER.trace("Received startup message code={}, length={}", (Object)requestCode, (Object)this.payloadLength);
                switch (requestCode) {
                    case 80877103: {
                        SslContext sslContext = this.getSslContext.get();
                        Channel channel = ctx.channel();
                        ByteBuf out = ctx.alloc().buffer(1);
                        if (sslContext == null) {
                            channel.writeAndFlush((Object)out.writeByte(78));
                        } else {
                            channel.writeAndFlush((Object)out.writeByte(83));
                            ctx.pipeline().addFirst(new ChannelHandler[]{sslContext.newHandler(ctx.alloc())});
                        }
                        if (in.readableBytes() < 8) {
                            return null;
                        }
                        return this.decode(ctx, in);
                    }
                    case 196608: 
                    case 80877102: {
                        if (in.readableBytes() < this.payloadLength) {
                            LOGGER.trace("Readable bytes: {} < payloadLength: {}. Reset buffer", (Object)in.readableBytes(), (Object)this.payloadLength);
                            in.resetReaderIndex();
                            return null;
                        }
                        this.state = requestCode == 80877102 ? State.CANCEL : State.STARTUP_PARAMETERS;
                        return in.readBytes(this.payloadLength);
                    }
                }
                in.skipBytes(in.readableBytes());
                int major = requestCode >> 16;
                int minor = requestCode & 0xFFFF;
                throw new IllegalStateException("Unsupported frontend protocol " + major + "." + minor + ": server supports 3.0 to 3.0");
            }
            case 3: {
                if (in.readableBytes() < 5) {
                    return null;
                }
                in.markReaderIndex();
                this.msgType = in.readByte();
                this.payloadLength = in.readInt() - 4;
                if (in.readableBytes() < this.payloadLength) {
                    in.resetReaderIndex();
                    return null;
                }
                return in.readBytes(this.payloadLength);
            }
        }
        in.skipBytes(in.readableBytes());
        throw new IllegalStateException("Invalid state " + String.valueOf((Object)this.state));
    }

    public void startupDone() {
        assert (this.state == State.STARTUP_PARAMETERS) : "Must only call startupDone if state == STARTUP_PARAMETERS";
        this.state = State.MSG;
    }

    public byte msgType() {
        return this.msgType;
    }

    public int payloadLength() {
        return this.payloadLength;
    }

    public State state() {
        return this.state;
    }

    public static enum State {
        STARTUP,
        STARTUP_PARAMETERS,
        CANCEL,
        MSG;

    }
}

