/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import io.crate.auth.AccessControl;
import io.crate.data.Row;
import io.crate.protocols.postgres.DelayableWriteChannel;
import io.crate.protocols.postgres.Messages;
import io.crate.session.BaseResultReceiver;
import io.netty.channel.ChannelFuture;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RowCountReceiver
extends BaseResultReceiver {
    private final DelayableWriteChannel channel;
    private final String query;
    private final AccessControl accessControl;
    private final DelayableWriteChannel.DelayedWrites delayedWrites;
    private long rowCount;

    RowCountReceiver(String query, DelayableWriteChannel channel, DelayableWriteChannel.DelayedWrites delayedWrites, AccessControl accessControl) {
        this.query = query;
        this.channel = channel;
        this.delayedWrites = delayedWrites;
        this.accessControl = accessControl;
    }

    @Override
    @Nullable
    public CompletableFuture<Void> setNextRow(Row row) {
        this.rowCount = (Long)row.get(0);
        if (this.rowCount < 0L) {
            --this.rowCount;
        }
        return null;
    }

    @Override
    public void allFinished() {
        ChannelFuture sendCommandComplete = Messages.sendCommandComplete(this.channel.bypassDelay(), this.query, this.rowCount);
        this.channel.writePendingMessages(this.delayedWrites);
        this.channel.flush();
        sendCommandComplete.addListener(f -> super.allFinished());
    }

    @Override
    public void fail(@NotNull Throwable throwable) {
        ChannelFuture sendErrorResponse = Messages.sendErrorResponse(this.channel.bypassDelay(), this.accessControl, throwable);
        this.channel.writePendingMessages(this.delayedWrites);
        this.channel.flush();
        sendErrorResponse.addListener(f -> super.fail(throwable));
    }
}

