/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.PGArray;
import io.crate.protocols.postgres.types.PGType;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

class CharType
extends PGType<Byte> {
    public static final CharType INSTANCE = new CharType();
    static final int OID = 18;

    private CharType() {
        super(18, 1, -1, "char");
    }

    @Override
    public int typArray() {
        return PGArray.CHAR_ARRAY.oid();
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.STRING.code();
    }

    @Override
    public String type() {
        return PGType.Type.BASE.code();
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, @NotNull Byte value) {
        buffer.writeInt(1);
        buffer.writeByte((int)value.byteValue());
        return 5;
    }

    @Override
    public Byte readBinaryValue(ByteBuf buffer, int valueLength) {
        assert (valueLength == 1) : "char must have 1 byte";
        return buffer.readByte();
    }

    @Override
    byte[] encodeAsUTF8Text(@NotNull Byte value) {
        return Byte.toString(value).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    Byte decodeUTF8Text(byte[] bytes) {
        return Byte.parseByte(new String(bytes, StandardCharsets.UTF_8));
    }
}

