/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.PGArray;
import io.crate.protocols.postgres.types.PGType;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

class IntegerType
extends PGType<Integer> {
    static final int OID = 23;
    private static final int TYPE_LEN = 4;
    private static final int TYPE_MOD = -1;
    public static final IntegerType INSTANCE = new IntegerType();

    private IntegerType() {
        super(23, 4, -1, "int4");
    }

    @Override
    public int typArray() {
        return PGArray.INT4_ARRAY.oid();
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.NUMERIC.code();
    }

    @Override
    public String type() {
        return PGType.Type.BASE.code();
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, @NotNull Integer value) {
        buffer.writeInt(4);
        buffer.writeInt(value.intValue());
        return 8;
    }

    @Override
    protected byte[] encodeAsUTF8Text(@NotNull Integer value) {
        return Integer.toString(value).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Integer readBinaryValue(ByteBuf buffer, int valueLength) {
        assert (valueLength == 4) : "length should be 4 because int is int32. Actual length: " + valueLength;
        return buffer.readInt();
    }

    @Override
    Integer decodeUTF8Text(byte[] bytes) {
        return Integer.parseInt(new String(bytes, StandardCharsets.UTF_8));
    }
}

