/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.PGArray;
import io.crate.protocols.postgres.types.PGType;
import io.crate.types.Regproc;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

public class IntervalType
extends PGType<Period> {
    private static final int OID = 1186;
    private static final int TYPE_LEN = 16;
    private static final int TYPE_MOD = -1;
    public static final IntervalType INSTANCE = new IntervalType();

    private IntervalType() {
        super(1186, 16, -1, "interval");
    }

    @Override
    public int typArray() {
        return PGArray.INTERVAL_ARRAY.oid();
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.TIMESPAN.code();
    }

    @Override
    public String type() {
        return PGType.Type.BASE.code();
    }

    @Override
    public Regproc typSend() {
        return Regproc.of("interval_send");
    }

    @Override
    public Regproc typReceive() {
        return Regproc.of("interval_recv");
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, @NotNull Period period) {
        buffer.writeInt(16);
        buffer.writeLong((long)(period.getHours() * 60 * 60) * 1000000L + (long)(period.getMinutes() * 60) * 1000000L + (long)period.getSeconds() * 1000000L + (long)(period.getMillis() * 1000));
        buffer.writeInt(period.getWeeks() * 7 + period.getDays());
        buffer.writeInt(period.getYears() * 12 + period.getMonths());
        return 20;
    }

    @Override
    public Period readBinaryValue(ByteBuf buffer, int valueLength) {
        assert (valueLength == 16) : "length should be 16 because interval is 16. Actual length: " + valueLength;
        long micros = buffer.readLong();
        int days = buffer.readInt();
        int months = buffer.readInt();
        long microsInAnHour = 3600000000L;
        int hours = Math.toIntExact(micros / microsInAnHour);
        long microsWithoutHours = micros % microsInAnHour;
        long microsInAMinute = 60000000L;
        int minutes = Math.toIntExact(microsWithoutHours / microsInAMinute);
        long microsWithoutMinutes = microsWithoutHours % microsInAMinute;
        int seconds = Math.toIntExact(microsWithoutMinutes / 1000000L);
        int millis = Math.toIntExact(microsWithoutMinutes % 1000000L / 1000L);
        return new Period(months / 12, months % 12, days / 7, days % 7, hours, minutes, seconds, millis);
    }

    @Override
    byte[] encodeAsUTF8Text(@NotNull Period value) {
        StringBuffer sb = new StringBuffer();
        io.crate.types.IntervalType.PERIOD_FORMATTER.printTo(sb, (ReadablePeriod)value);
        return sb.toString().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    Period decodeUTF8Text(byte[] bytes) {
        return io.crate.types.IntervalType.PERIOD_FORMATTER.parsePeriod(new String(bytes, StandardCharsets.UTF_8));
    }
}

