/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.common.collections.Lists;
import io.crate.protocols.postgres.types.PGArray;
import io.crate.protocols.postgres.types.PGType;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.VisibleForTesting;

public class PgOidVectorType
extends PGType<List<Integer>> {
    public static final PgOidVectorType INSTANCE = new PgOidVectorType();
    private static final int OID = 30;

    PgOidVectorType() {
        super(30, -1, -1, "oidvector");
    }

    @Override
    public int typArray() {
        return 1013;
    }

    @Override
    public int typElem() {
        return 26;
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.ARRAY.code();
    }

    @Override
    public String type() {
        return PGType.Type.BASE.code();
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, List<Integer> value) {
        return PGArray.INT4_ARRAY.writeAsBinary(buffer, value);
    }

    @Override
    public List<Integer> readBinaryValue(ByteBuf buffer, int valueLength) {
        return PGArray.INT4_ARRAY.readBinaryValue(buffer, valueLength);
    }

    @Override
    byte[] encodeAsUTF8Text(List<Integer> value) {
        return Lists.joinOn((String)" ", value, x -> Integer.toString(x)).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    List<Integer> decodeUTF8Text(byte[] bytes) {
        String string = new String(bytes, StandardCharsets.UTF_8);
        return PgOidVectorType.listFromOidVectorString(string);
    }

    @VisibleForTesting
    public static List<Integer> listFromOidVectorString(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, " ");
        ArrayList<Integer> oids = new ArrayList<Integer>();
        while (tokenizer.hasMoreTokens()) {
            oids.add(Integer.parseInt(tokenizer.nextToken()));
        }
        return oids;
    }
}

