/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.PGArray;
import io.crate.protocols.postgres.types.PGType;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

class SmallIntType
extends PGType<Short> {
    public static final SmallIntType INSTANCE = new SmallIntType();
    static final int OID = 21;
    private static final int TYPE_LEN = 2;
    private static final int TYPE_MOD = -1;

    private SmallIntType() {
        super(21, 2, -1, "int2");
    }

    @Override
    public int typArray() {
        return PGArray.INT2_ARRAY.oid();
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.NUMERIC.code();
    }

    @Override
    public String type() {
        return PGType.Type.BASE.code();
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, @NotNull Short value) {
        buffer.writeInt(2);
        buffer.writeShort((int)value.shortValue());
        return 6;
    }

    @Override
    protected byte[] encodeAsUTF8Text(@NotNull Short value) {
        return Short.toString(value).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Short readBinaryValue(ByteBuf buffer, int valueLength) {
        assert (valueLength == 2) : "length should be 2 because short is int16. Actual length: " + valueLength;
        return buffer.readShort();
    }

    @Override
    Short decodeUTF8Text(byte[] bytes) {
        return Short.parseShort(new String(bytes, StandardCharsets.UTF_8));
    }
}

