/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.action;

import io.crate.replication.logical.action.RestoreShardRequest;
import io.crate.replication.logical.repository.PublisherRestoreService;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.Nullable;

public class ReleasePublisherResourcesAction
extends ActionType<AcknowledgedResponse> {
    public static final String NAME = "internal:crate:replication/logical/resources/release";
    public static final ReleasePublisherResourcesAction INSTANCE = new ReleasePublisherResourcesAction();

    public ReleasePublisherResourcesAction() {
        super(NAME);
    }

    @Override
    public Writeable.Reader<AcknowledgedResponse> getResponseReader() {
        return AcknowledgedResponse::new;
    }

    public static class Request
    extends RestoreShardRequest<Request> {
        public Request(String restoreUUID, DiscoveryNode node, ShardId shardId, String subscriberClusterName) {
            super(restoreUUID, node, shardId, subscriberClusterName);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }
    }

    @Singleton
    public static class TransportAction
    extends TransportSingleShardAction<Request, AcknowledgedResponse> {
        private static final Logger LOGGER = LogManager.getLogger(TransportAction.class);
        private final PublisherRestoreService publisherRestoreService;

        @Inject
        public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, PublisherRestoreService publisherRestoreService) {
            super(ReleasePublisherResourcesAction.NAME, threadPool, clusterService, transportService, Request::new, "get");
            this.publisherRestoreService = publisherRestoreService;
            TransportActionProxy.registerProxyAction(transportService, ReleasePublisherResourcesAction.NAME, AcknowledgedResponse::new);
        }

        @Override
        protected AcknowledgedResponse shardOperation(Request request, ShardId shardId) throws IOException {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Releasing resources for {} with restore-id as {}", (Object)shardId, (Object)request.restoreUUID());
            }
            this.publisherRestoreService.removeRestoreContext(request.restoreUUID());
            return new AcknowledgedResponse(true);
        }

        @Override
        protected Writeable.Reader<AcknowledgedResponse> getResponseReader() {
            return AcknowledgedResponse::new;
        }

        @Override
        @Nullable
        protected ShardsIterator shards(ClusterState state, Request request) {
            return state.routingTable().shardRoutingTable(request.shardId()).primaryShardIt();
        }
    }
}

