/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.analyze;

import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.FieldProvider;
import io.crate.common.collections.Lists;
import io.crate.exceptions.InvalidArgumentException;
import io.crate.exceptions.RelationUnknown;
import io.crate.exceptions.UnauthorizedException;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.metadata.table.Operation;
import io.crate.replication.logical.LogicalReplicationService;
import io.crate.replication.logical.analyze.AnalyzedAlterPublication;
import io.crate.replication.logical.analyze.AnalyzedAlterSubscription;
import io.crate.replication.logical.analyze.AnalyzedCreatePublication;
import io.crate.replication.logical.analyze.AnalyzedCreateSubscription;
import io.crate.replication.logical.analyze.AnalyzedDropPublication;
import io.crate.replication.logical.analyze.AnalyzedDropSubscription;
import io.crate.replication.logical.exceptions.PublicationAlreadyExistsException;
import io.crate.replication.logical.exceptions.PublicationUnknownException;
import io.crate.replication.logical.exceptions.SubscriptionAlreadyExistsException;
import io.crate.replication.logical.exceptions.SubscriptionUnknownException;
import io.crate.replication.logical.metadata.Publication;
import io.crate.replication.logical.metadata.Subscription;
import io.crate.sql.tree.AlterPublication;
import io.crate.sql.tree.AlterSubscription;
import io.crate.sql.tree.CreatePublication;
import io.crate.sql.tree.CreateSubscription;
import io.crate.sql.tree.DropPublication;
import io.crate.sql.tree.DropSubscription;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.QualifiedName;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.index.IndexSettings;

public class LogicalReplicationAnalyzer {
    private final Schemas schemas;
    private final LogicalReplicationService logicalReplicationService;
    private final NodeContext nodeCtx;

    public LogicalReplicationAnalyzer(Schemas schemas, LogicalReplicationService logicalReplicationService, NodeContext nodeCtx) {
        this.schemas = schemas;
        this.logicalReplicationService = logicalReplicationService;
        this.nodeCtx = nodeCtx;
    }

    public AnalyzedCreatePublication analyze(CreatePublication createPublication, CoordinatorTxnCtx txnCtx) {
        if (this.logicalReplicationService.publications().containsKey(createPublication.name())) {
            throw new PublicationAlreadyExistsException(createPublication.name());
        }
        List tables = Lists.map((Collection)createPublication.tables(), q -> {
            CoordinatorSessionSettings sessionSettings = txnCtx.sessionSettings();
            DocTableInfo tableInfo = (DocTableInfo)this.schemas.findRelation((QualifiedName)q, Operation.CREATE_PUBLICATION, sessionSettings.sessionUser(), sessionSettings.searchPath());
            boolean softDeletes = IndexSettings.INDEX_SOFT_DELETES_SETTING.get(tableInfo.parameters());
            if (!softDeletes) {
                throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Tables included in a publication must have the table setting 'soft_deletes.enabled' set to `true`, current setting for table '%s': %b", tableInfo.ident(), softDeletes));
            }
            return tableInfo.ident();
        });
        return new AnalyzedCreatePublication(createPublication.name(), createPublication.isForAllTables(), tables);
    }

    public AnalyzedDropPublication analyze(DropPublication dropPublication, CoordinatorSessionSettings sessionSettings) {
        Publication publication = this.logicalReplicationService.publications().get(dropPublication.name());
        if (!dropPublication.ifExists() && publication == null) {
            throw new PublicationUnknownException(dropPublication.name());
        }
        if (publication != null && !publication.owner().equals(sessionSettings.sessionUser().name()) && !sessionSettings.sessionUser().isSuperUser()) {
            throw new UnauthorizedException("A publication can only be dropped by the owner or a superuser");
        }
        return new AnalyzedDropPublication(dropPublication.name(), dropPublication.ifExists());
    }

    public AnalyzedAlterPublication analyze(AlterPublication alterPublication, CoordinatorSessionSettings sessionSettings) {
        Publication publication = this.logicalReplicationService.publications().get(alterPublication.name());
        if (publication == null) {
            throw new PublicationUnknownException(alterPublication.name());
        }
        if (!publication.owner().equals(sessionSettings.sessionUser().name()) && !sessionSettings.sessionUser().isSuperUser()) {
            throw new UnauthorizedException("A publication can only be altered by the owner or a superuser");
        }
        if (publication.isForAllTables()) {
            throw new InvalidArgumentException("Publication '" + alterPublication.name() + "' is defined as FOR ALL TABLES, adding or dropping tables is not supported");
        }
        String defaultSchema = sessionSettings.searchPath().currentSchema();
        List tables = Lists.map((Collection)alterPublication.tables(), q -> {
            RelationName relation = RelationName.of(q, defaultSchema);
            if (!this.schemas.tableExists(relation)) {
                throw new RelationUnknown(relation);
            }
            return relation;
        });
        return new AnalyzedAlterPublication(alterPublication.name(), alterPublication.operation(), tables);
    }

    public AnalyzedCreateSubscription analyze(CreateSubscription<Expression> createSubscription, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        if (this.logicalReplicationService.subscriptions().containsKey(createSubscription.name())) {
            throw new SubscriptionAlreadyExistsException(createSubscription.name());
        }
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.TO_LITERAL_VALIDATE_NAME, null);
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext(txnCtx.sessionSettings());
        GenericProperties genericProperties = createSubscription.properties().map(p -> expressionAnalyzer.convert((Expression)p, exprCtx));
        Symbol connectionInfo = expressionAnalyzer.convert((Expression)createSubscription.connectionInfo(), exprCtx);
        return new AnalyzedCreateSubscription(createSubscription.name(), connectionInfo, createSubscription.publications(), (GenericProperties<Symbol>)genericProperties);
    }

    public AnalyzedDropSubscription analyze(DropSubscription dropSubscription, CoordinatorSessionSettings sessionSettings) {
        Subscription subscription = this.logicalReplicationService.subscriptions().get(dropSubscription.name());
        if (!dropSubscription.ifExists() && subscription == null) {
            throw new SubscriptionUnknownException(dropSubscription.name());
        }
        if (subscription != null && !subscription.owner().equals(sessionSettings.sessionUser().name()) && !sessionSettings.sessionUser().isSuperUser()) {
            throw new UnauthorizedException("A subscription can only be dropped by the owner or a superuser");
        }
        return new AnalyzedDropSubscription(dropSubscription.name(), subscription, dropSubscription.ifExists());
    }

    public AnalyzedAlterSubscription analyze(AlterSubscription alterSubscription, CoordinatorSessionSettings sessionSettings) {
        Subscription subscription = this.logicalReplicationService.subscriptions().get(alterSubscription.name());
        if (subscription == null) {
            throw new SubscriptionUnknownException(alterSubscription.name());
        }
        if (!subscription.owner().equals(sessionSettings.sessionUser().name()) && !sessionSettings.sessionUser().isSuperUser()) {
            throw new UnauthorizedException("A subscription can only be altered by the owner or a superuser");
        }
        return new AnalyzedAlterSubscription(alterSubscription.name(), alterSubscription.mode() == AlterSubscription.Mode.ENABLE);
    }
}

