/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.metadata;

import io.crate.replication.logical.exceptions.CreateSubscriptionException;
import io.crate.role.Role;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.RemoteCluster;
import org.jetbrains.annotations.Nullable;

public class ConnectionInfo
implements Writeable {
    public static final Setting<String> USERNAME = Setting.simpleString("user", new Setting.Property[0]);
    public static final Setting<String> PASSWORD = Setting.simpleString("password", new Setting.Property[0]);
    public static final Setting<SSLMode> SSLMODE = new Setting<SSLMode>("sslmode", SSLMode.PREFER.name(), input -> switch (input.toLowerCase(Locale.ENGLISH)) {
        case "prefer" -> SSLMode.PREFER;
        case "disable" -> SSLMode.DISABLE;
        case "require" -> SSLMode.REQUIRE;
        default -> throw new CreateSubscriptionException("Invalid value for sslmode: " + input + " expected one of: prefer, disable, require");
    }, DataTypes.STRING, new Setting.Property[0]);
    private static final Set<String> SUPPORTED_SETTINGS = Set.of(USERNAME.getKey(), PASSWORD.getKey(), SSLMODE.getKey(), RemoteCluster.REMOTE_CONNECTION_MODE.getKey());
    private static final String DEFAULT_PORT = "4300";
    private static final String DEFAULT_PG_PORT = "5432";
    private final List<String> hosts;
    private final Settings settings;
    private final RemoteCluster.ConnectionStrategy mode;

    public static ConnectionInfo fromURL(String url) {
        try {
            String[] args;
            String urlServer = url;
            String urlArgs = "";
            int qPos = url.indexOf(63);
            if (qPos != -1) {
                urlServer = url.substring(0, qPos);
                urlArgs = url.substring(qPos + 1);
            }
            Settings.Builder settingsBuilder = Settings.builder();
            for (String token : args = urlArgs.split("&")) {
                String settingValue;
                String settingName;
                if (token.isEmpty()) continue;
                int pos = token.indexOf(61);
                if (pos == -1) {
                    settingName = token;
                    settingValue = "";
                } else {
                    settingName = token.substring(0, pos);
                    settingValue = URLDecoder.decode(token.substring(pos + 1), StandardCharsets.UTF_8);
                }
                if (!SUPPORTED_SETTINGS.contains(settingName)) {
                    throw new CreateSubscriptionException(String.format(Locale.ENGLISH, "Connection string argument '%s' is not supported", settingName));
                }
                settingsBuilder.put(settingName, settingValue);
            }
            if (!urlServer.startsWith("crate://")) {
                throw new CreateSubscriptionException(String.format(Locale.ENGLISH, "The connection string must start with \"crate://\" but was: \"%s\"", url));
            }
            int slash = (urlServer = urlServer.substring("crate://".length())).indexOf(47);
            if (slash != -1) {
                if (slash != urlServer.length() - 1) {
                    throw new CreateSubscriptionException(String.format(Locale.ENGLISH, "Database name \"%s\" is not supported inside the connection string: %s", urlServer.substring(slash + 1), url));
                }
                urlServer = urlServer.substring(0, slash);
            }
            slash = urlServer.length();
            Settings settings = settingsBuilder.build();
            String[] addresses = urlServer.substring(0, slash).split(",");
            ArrayList<String> hosts = new ArrayList<String>();
            for (String address : addresses) {
                int portIdx = address.lastIndexOf(58);
                if (portIdx != -1 && address.lastIndexOf(93) < portIdx) {
                    String portStr = address.substring(portIdx + 1);
                    try {
                        int port = Integer.parseInt(portStr);
                        if (port < 1 || port > 65535) {
                            throw new CreateSubscriptionException(String.format(Locale.ENGLISH, "Invalid port number '%s' inside connection string (1:65535)", portStr));
                        }
                    }
                    catch (NumberFormatException ignore) {
                        throw new CreateSubscriptionException(String.format(Locale.ENGLISH, "Invalid port number '%s' inside connection string (1:65535)", portStr));
                    }
                    hosts.add(address);
                    continue;
                }
                hosts.add(address + ":" + ConnectionInfo.defaultPort(settings));
            }
            return new ConnectionInfo(hosts, settings);
        }
        catch (Exception e) {
            throw new CreateSubscriptionException(e);
        }
    }

    private static String defaultPort(Settings settings) {
        if (RemoteCluster.REMOTE_CONNECTION_MODE.get(settings) == RemoteCluster.ConnectionStrategy.PG_TUNNEL) {
            return DEFAULT_PG_PORT;
        }
        return DEFAULT_PORT;
    }

    public ConnectionInfo(List<String> hosts, Settings settings) {
        this.hosts = hosts;
        this.settings = settings;
        this.mode = RemoteCluster.REMOTE_CONNECTION_MODE.get(settings);
    }

    public ConnectionInfo(StreamInput in) throws IOException {
        this.hosts = Arrays.stream(in.readStringArray()).toList();
        this.settings = Settings.readSettingsFromStream(in);
        this.mode = RemoteCluster.REMOTE_CONNECTION_MODE.get(this.settings);
    }

    public List<String> hosts() {
        return this.hosts;
    }

    public String safeConnectionString() {
        Object str = String.format(Locale.ENGLISH, "crate://%s?user=*&password=*&mode=%s", String.join((CharSequence)",", this.hosts), this.mode.toString().toLowerCase(Locale.ENGLISH));
        if (this.mode == RemoteCluster.ConnectionStrategy.PG_TUNNEL) {
            str = (String)str + "&sslmode=" + this.sslMode().toString().toLowerCase(Locale.ENGLISH);
        }
        return str;
    }

    public Settings settings() {
        return this.settings;
    }

    public String user() {
        String userName = USERNAME.get(this.settings);
        return userName == null ? Role.CRATE_USER.name() : userName;
    }

    @Nullable
    public String password() {
        return PASSWORD.get(this.settings);
    }

    public SSLMode sslMode() {
        return SSLMODE.get(this.settings);
    }

    public RemoteCluster.ConnectionStrategy mode() {
        return this.mode;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.hosts.toArray(new String[0]));
        Settings.writeSettingsToStream(out, this.settings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionInfo that = (ConnectionInfo)o;
        return this.hosts.equals(that.hosts) && this.settings.equals(that.settings);
    }

    public int hashCode() {
        return Objects.hash(this.hosts, this.settings);
    }

    public static enum SSLMode {
        PREFER,
        DISABLE,
        REQUIRE;

    }
}

