/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.repository;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import io.crate.action.FutureActionListener;
import io.crate.common.exceptions.Exceptions;
import io.crate.common.io.IOUtils;
import io.crate.common.unit.TimeValue;
import io.crate.exceptions.SQLExceptions;
import io.crate.replication.logical.LogicalReplicationService;
import io.crate.replication.logical.LogicalReplicationSettings;
import io.crate.replication.logical.action.GetStoreMetadataAction;
import io.crate.replication.logical.action.PublicationsStateAction;
import io.crate.replication.logical.action.ReleasePublisherResourcesAction;
import io.crate.replication.logical.metadata.ConnectionInfo;
import io.crate.replication.logical.repository.RemoteClusterMultiChunkTransfer;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexCommit;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusters;
import org.jetbrains.annotations.Nullable;

public class LogicalReplicationRepository
extends AbstractLifecycleComponent
implements Repository {
    private static final Logger LOGGER = LogManager.getLogger(LogicalReplicationRepository.class);
    public static final String TYPE = "logical_replication";
    public static final String LATEST = "_latest_";
    public static final String REMOTE_REPOSITORY_PREFIX = "_logical_replication_";
    private static final SnapshotId SNAPSHOT_ID = new SnapshotId("_latest_", "_latest_");
    public static final long REMOTE_CLUSTER_REPO_REQ_TIMEOUT_IN_MILLI_SEC = 60000L;
    private final LogicalReplicationService logicalReplicationService;
    private final RepositoryMetadata metadata;
    private final String subscriptionName;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final RemoteClusters remoteClusters;
    private final LogicalReplicationSettings replicationSettings;

    public LogicalReplicationRepository(ClusterService clusterService, LogicalReplicationService logicalReplicationService, RemoteClusters remoteClusters, RepositoryMetadata metadata, ThreadPool threadPool, LogicalReplicationSettings replicationSettings) {
        this.clusterService = clusterService;
        this.logicalReplicationService = logicalReplicationService;
        this.remoteClusters = remoteClusters;
        this.metadata = metadata;
        assert (metadata.name().startsWith(REMOTE_REPOSITORY_PREFIX)) : "SubscriptionRepository metadata.name() must start with: _logical_replication_";
        this.subscriptionName = Strings.split(metadata.name(), REMOTE_REPOSITORY_PREFIX)[1];
        this.threadPool = threadPool;
        this.replicationSettings = replicationSettings;
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() throws IOException {
    }

    @Override
    public RepositoryMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public CompletableFuture<SnapshotInfo> getSnapshotInfo(SnapshotId snapshotId) {
        assert (SNAPSHOT_ID.equals(snapshotId)) : "SubscriptionRepository only supports " + String.valueOf(SNAPSHOT_ID) + " as the SnapshotId";
        return this.getPublicationsState().thenApply(stateResponse -> new SnapshotInfo(snapshotId, stateResponse.concreteIndices().stream().filter(im -> LogicalReplicationSettings.REPLICATION_INDEX_ROUTING_ACTIVE.get(im.getSettings())).map(im -> im.getIndex().getName()).toList(), SnapshotState.SUCCESS, Version.CURRENT));
    }

    @Override
    public CompletableFuture<Metadata> getSnapshotGlobalMetadata(SnapshotId snapshotId) {
        return ((CompletableFuture)this.getPublicationsState().thenCompose(resp -> this.getRemoteClusterState(false, true, resp.concreteIndices().stream().map(im -> im.getIndex().getName()).toList(), resp.concreteTemplates()))).thenApply(remoteClusterStateResp -> {
            ClusterState remoteClusterState = remoteClusterStateResp.getState();
            Metadata.Builder metadataBuilder = Metadata.builder(remoteClusterState.metadata());
            for (ObjectCursor cursor : remoteClusterState.metadata().templates().values()) {
                Settings settings = Settings.builder().put(((IndexTemplateMetadata)cursor.value).settings()).put(LogicalReplicationSettings.REPLICATION_SUBSCRIPTION_NAME.getKey(), this.subscriptionName).build();
                IndexTemplateMetadata.Builder templateMetadata = new IndexTemplateMetadata.Builder((IndexTemplateMetadata)cursor.value).settings(settings);
                metadataBuilder.put(templateMetadata);
            }
            return metadataBuilder.build();
        });
    }

    @Override
    public CompletableFuture<Collection<IndexMetadata>> getSnapshotIndexMetadata(RepositoryData repositoryData, SnapshotId snapshotId, Collection<IndexId> indexIds) {
        assert (SNAPSHOT_ID.equals(snapshotId)) : "SubscriptionRepository only supports " + String.valueOf(SNAPSHOT_ID) + " as the SnapshotId";
        String[] remoteIndices = (String[])indexIds.stream().map(IndexId::getName).toArray(String[]::new);
        return this.getRemoteClusterState(remoteIndices).thenApply(response -> {
            ArrayList<IndexMetadata> result = new ArrayList<IndexMetadata>();
            ClusterState remoteClusterState = response.getState();
            for (ObjectObjectCursor<String, IndexMetadata> objectObjectCursor : remoteClusterState.metadata().indices()) {
                if (!remoteClusterState.routingTable().index((String)objectObjectCursor.key).allPrimaryShardsActive()) continue;
                IndexMetadata indexMetadata = (IndexMetadata)objectObjectCursor.value;
                Settings.Builder builder = Settings.builder().put(indexMetadata.getSettings());
                builder.put(LogicalReplicationSettings.REPLICATION_SUBSCRIPTION_NAME.getKey(), this.subscriptionName);
                builder.put(LogicalReplicationSettings.PUBLISHER_INDEX_UUID.getKey(), indexMetadata.getIndexUUID());
                builder.remove(LogicalReplicationSettings.REPLICATION_INDEX_ROUTING_ACTIVE.getKey());
                IndexMetadata.Builder indexMdBuilder = IndexMetadata.builder(indexMetadata).settings(builder);
                indexMetadata.getAliases().valuesIt().forEachRemaining(indexMdBuilder::putAlias);
                result.add(indexMdBuilder.build());
            }
            return result;
        });
    }

    @Override
    public CompletableFuture<IndexMetadata> getSnapshotIndexMetadata(RepositoryData repositoryData, SnapshotId snapshotId, IndexId index) {
        assert (SNAPSHOT_ID.equals(snapshotId)) : "SubscriptionRepository only supports " + String.valueOf(SNAPSHOT_ID) + " as the SnapshotId";
        return this.getRemoteClusterState(index.getName()).thenApply(response -> {
            ClusterState remoteClusterState = response.getState();
            IndexMetadata indexMetadata = remoteClusterState.metadata().index(index.getName());
            Settings.Builder builder = Settings.builder().put(indexMetadata.getSettings());
            builder.put(LogicalReplicationSettings.REPLICATION_SUBSCRIPTION_NAME.getKey(), this.subscriptionName);
            builder.put(LogicalReplicationSettings.PUBLISHER_INDEX_UUID.getKey(), indexMetadata.getIndexUUID());
            IndexMetadata.Builder indexMdBuilder = IndexMetadata.builder(indexMetadata).settings(builder);
            indexMetadata.getAliases().valuesIt().forEachRemaining(a -> indexMdBuilder.putAlias((AliasMetadata)a));
            return indexMdBuilder.build();
        });
    }

    @Override
    public CompletableFuture<RepositoryData> getRepositoryData() {
        return ((CompletableFuture)this.getPublicationsState().thenCompose(resp -> this.getRemoteClusterState(false, false, resp.concreteIndices().stream().map(im -> im.getIndex().getName()).toList(), resp.concreteTemplates()))).thenApply(remoteStateResp -> {
            ClusterState remoteClusterState = remoteStateResp.getState();
            Metadata remoteMetadata = remoteClusterState.metadata();
            ShardGenerations.Builder shardGenerations = ShardGenerations.builder();
            Iterator<IndexMetadata> it = remoteMetadata.indices().valuesIt();
            while (it.hasNext()) {
                IndexMetadata indexMetadata = it.next();
                IndexId indexId = new IndexId(indexMetadata.getIndex().getName(), indexMetadata.getIndexUUID());
                for (int i = 0; i < indexMetadata.getNumberOfShards(); ++i) {
                    shardGenerations.put(indexId, i, "dummy");
                }
            }
            return RepositoryData.EMPTY.addSnapshot(SNAPSHOT_ID, SnapshotState.SUCCESS, Version.CURRENT, shardGenerations.build(), null, null);
        });
    }

    @Override
    public void finalizeSnapshot(ShardGenerations shardGenerations, long repositoryStateId, Metadata clusterMetadata, SnapshotInfo snapshotInfo, Version repositoryMetaVersion, UnaryOperator<ClusterState> stateTransformer, ActionListener<RepositoryData> listener) {
        throw new UnsupportedOperationException("Operation not permitted");
    }

    @Override
    public void deleteSnapshots(Collection<SnapshotId> snapshotId, long repositoryStateId, Version repositoryMetaVersion, ActionListener<RepositoryData> listener) {
        throw new UnsupportedOperationException("Operation not permitted");
    }

    @Override
    public String startVerification() {
        throw new UnsupportedOperationException("Operation not permitted");
    }

    @Override
    public void endVerification(String verificationToken) {
        throw new UnsupportedOperationException("Operation not permitted");
    }

    @Override
    public void verify(String verificationToken, DiscoveryNode localNode) {
        throw new UnsupportedOperationException("Operation not permitted");
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void snapshotShard(Store store, SnapshotId snapshotId, IndexId indexId, IndexCommit snapshotIndexCommit, @Nullable String shardStateIdentifier, IndexShardSnapshotStatus snapshotStatus, Version repositoryMetaVersion, ActionListener<String> listener) {
        throw new UnsupportedOperationException("Operation not permitted");
    }

    @Override
    public void updateState(ClusterState state) {
        throw new UnsupportedOperationException("Operation not permitted");
    }

    @Override
    public void executeConsistentStateUpdate(Function<RepositoryData, ClusterStateUpdateTask> createUpdateTask, String source, Consumer<Exception> onFailure) {
        throw new UnsupportedOperationException("Operation not permitted");
    }

    @Override
    public void restoreShard(final Store store, SnapshotId snapshotId, IndexId indexId, ShardId snapshotShardId, RecoveryState recoveryState, final ActionListener<Void> listener) {
        store.incRef();
        ActionListener<Void> releaseListener = new ActionListener<Void>(){

            @Override
            public void onResponse(Void response) {
                store.decRef();
                listener.onResponse(response);
            }

            @Override
            public void onFailure(Exception e) {
                store.decRef();
                listener.onFailure(e);
            }
        };
        this.restoreShardUsingMultiChunkTransfer(store, indexId, snapshotShardId, recoveryState, releaseListener);
    }

    private void restoreShardUsingMultiChunkTransfer(Store store, IndexId indexId, ShardId snapshotShardId, RecoveryState recoveryState, ActionListener<Void> listener) {
        CompletableFuture<ClusterStateResponse> remoteClusterState = this.getRemoteClusterState(true, true, List.of(indexId.getName()), List.of());
        remoteClusterState.whenComplete((resp, err) -> {
            if (err != null) {
                listener.onFailure(Exceptions.toException((Throwable)err));
                return;
            }
            ClusterState publisherClusterState = resp.getState();
            ShardRouting publisherShardRouting = publisherClusterState.routingTable().shardRoutingTable(snapshotShardId.getIndexName(), snapshotShardId.id()).primaryShard();
            DiscoveryNode publisherShardNode = publisherClusterState.nodes().get(publisherShardRouting.currentNodeId());
            ShardId shardId = new ShardId(snapshotShardId.getIndexName(), publisherClusterState.metadata().index(indexId.getName()).getIndexUUID(), snapshotShardId.id());
            String restoreUUID = UUIDs.randomBase64UUID();
            GetStoreMetadataAction.Request getStoreMetadataRequest = new GetStoreMetadataAction.Request(restoreUUID, publisherShardNode, shardId, this.clusterService.getClusterName().value());
            Client remoteClient = this.getRemoteClient();
            StepListener<GetStoreMetadataAction.Response> responseStepListener = new StepListener<GetStoreMetadataAction.Response>();
            remoteClient.execute(GetStoreMetadataAction.INSTANCE, getStoreMetadataRequest).whenComplete(responseStepListener);
            responseStepListener.whenComplete(metadataResponse -> {
                Store.MetadataSnapshot metadataSnapshot = metadataResponse.metadataSnapshot();
                ArrayList<StoreFileMetadata> fileMetadata = new ArrayList<StoreFileMetadata>(metadataSnapshot.asMap().values());
                FutureActionListener<Void> chunkTransferCompleted = new FutureActionListener<Void>();
                chunkTransferCompleted.whenComplete((result, throwable) -> {
                    if (throwable == null) {
                        LOGGER.info("Restore successful for {}", (Object)store.shardId());
                        this.releasePublisherResources(remoteClient, restoreUUID, publisherShardNode, shardId);
                        recoveryState.getIndex().setFileDetailsComplete();
                        listener.onResponse(null);
                    } else {
                        LOGGER.error("Restore of " + String.valueOf(store.shardId()) + " failed due to ", throwable);
                        this.releasePublisherResources(remoteClient, restoreUUID, publisherShardNode, shardId);
                        listener.onFailure(Exceptions.toException((Throwable)throwable));
                    }
                });
                RemoteClusterMultiChunkTransfer multiChunkTransfer = new RemoteClusterMultiChunkTransfer(LOGGER, this.clusterService.getClusterName().value(), store, this.replicationSettings.maxConcurrentFileChunks(), restoreUUID, publisherShardNode, shardId, fileMetadata, remoteClient, this.threadPool, recoveryState, this.replicationSettings.recoveryChunkSize(), chunkTransferCompleted);
                chunkTransferCompleted.whenComplete((result, throwable) -> IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{multiChunkTransfer}));
                if (fileMetadata.isEmpty()) {
                    LOGGER.info("Initializing with empty store for shard: {}", (Object)shardId.id());
                    try {
                        store.createEmpty(store.indexSettings().getIndexVersionCreated().luceneVersion);
                        listener.onResponse(null);
                    }
                    catch (IOException e) {
                        listener.onFailure(new UncheckedIOException(e));
                    }
                    finally {
                        this.releasePublisherResources(remoteClient, restoreUUID, publisherShardNode, shardId);
                    }
                } else {
                    multiChunkTransfer.start();
                }
            }, listener::onFailure);
        });
    }

    private Client getRemoteClient() {
        return this.remoteClusters.getClient(this.subscriptionName);
    }

    private CompletableFuture<ClusterStateResponse> getRemoteClusterState(String ... remoteIndices) {
        return this.getRemoteClusterState(false, true, Arrays.asList(remoteIndices), List.of());
    }

    private CompletableFuture<ClusterStateResponse> getRemoteClusterState(boolean includeNodes, boolean includeRouting, List<String> remoteIndices, List<String> remoteTemplates) {
        Client remoteClient = this.getRemoteClient();
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest().indices(remoteIndices.toArray(new String[0])).templates(remoteTemplates.toArray(new String[0])).metadata(true).nodes(includeNodes).routingTable(includeRouting).indicesOptions(IndicesOptions.STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED).waitForTimeout(new TimeValue(60000L));
        return remoteClient.admin().cluster().state(clusterStateRequest);
    }

    private CompletableFuture<PublicationsStateAction.Response> getPublicationsState() {
        return this.getRemoteClient().execute(PublicationsStateAction.INSTANCE, new PublicationsStateAction.Request(this.logicalReplicationService.subscriptions().get(this.subscriptionName).publications(), this.logicalReplicationService.subscriptions().get(this.subscriptionName).connectionInfo().settings().get(ConnectionInfo.USERNAME.getKey())));
    }

    private void releasePublisherResources(Client remoteClient, String restoreUUID, DiscoveryNode publisherShardNode, ShardId shardId) {
        ReleasePublisherResourcesAction.Request releaseResourcesReq = new ReleasePublisherResourcesAction.Request(restoreUUID, publisherShardNode, shardId, this.clusterService.getClusterName().value());
        remoteClient.execute(ReleasePublisherResourcesAction.INSTANCE, releaseResourcesReq).whenComplete((response, err) -> {
            if (err == null) {
                if (response.isAcknowledged() && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Successfully released resources at the publisher cluster for {} at {}", (Object)shardId, (Object)publisherShardNode);
                }
            } else {
                LOGGER.error("Releasing publisher resource failed due to ", SQLExceptions.unwrap(err));
            }
        });
    }

    @Override
    public CompletableFuture<IndexShardSnapshotStatus> getShardSnapshotStatus(SnapshotId snapshotId, IndexId indexId, ShardId shardId) {
        return CompletableFuture.completedFuture(null);
    }
}

