/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role;

import io.crate.fdw.ServersMetadata;
import io.crate.role.DropRoleRequest;
import io.crate.role.Role;
import io.crate.role.WriteRoleResponse;
import io.crate.role.metadata.RolesMetadata;
import io.crate.role.metadata.UsersMetadata;
import io.crate.role.metadata.UsersPrivilegesMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Priority;
import org.jetbrains.annotations.VisibleForTesting;

public class DropRoleTask
extends AckedClusterStateUpdateTask<WriteRoleResponse> {
    private final DropRoleRequest request;
    private boolean alreadyExists = true;

    DropRoleTask(DropRoleRequest request) {
        super(Priority.URGENT, request);
        this.request = request;
    }

    @Override
    public ClusterState execute(ClusterState currentState) throws Exception {
        Metadata currentMetadata = currentState.metadata();
        DropRoleTask.ensureUserDoesNotOwnForeignServers(currentMetadata, this.request.roleName());
        Metadata.Builder mdBuilder = Metadata.builder(currentMetadata);
        this.alreadyExists = DropRoleTask.dropRole(mdBuilder, this.request.roleName());
        return ClusterState.builder(currentState).metadata(mdBuilder).build();
    }

    @Override
    protected WriteRoleResponse newResponse(boolean acknowledged) {
        return new WriteRoleResponse(acknowledged, this.alreadyExists);
    }

    @VisibleForTesting
    static boolean dropRole(Metadata.Builder mdBuilder, String roleNameToDrop) {
        RolesMetadata oldRolesMetadata = (RolesMetadata)mdBuilder.getCustom("roles");
        UsersMetadata oldUsersMetadata = (UsersMetadata)mdBuilder.getCustom("users");
        if (oldUsersMetadata == null && oldRolesMetadata == null) {
            return false;
        }
        UsersPrivilegesMetadata oldUserPrivilegesMetadata = (UsersPrivilegesMetadata)mdBuilder.getCustom("users_privileges");
        RolesMetadata newMetadata = RolesMetadata.of(mdBuilder, oldUsersMetadata, oldUserPrivilegesMetadata, oldRolesMetadata);
        DropRoleTask.ensureHasNoDependencies(newMetadata.roles().values(), roleNameToDrop);
        Role role = newMetadata.remove(roleNameToDrop);
        if (role == null && newMetadata.equals(oldRolesMetadata)) {
            return false;
        }
        assert (!newMetadata.equals(oldRolesMetadata)) : "must not be equal to guarantee the cluster change action";
        mdBuilder.putCustom("roles", newMetadata);
        return role != null;
    }

    private static void ensureHasNoDependencies(Collection<Role> roles, String roleNameToDrop) {
        for (Role role : roles) {
            if (!role.grantedRoleNames().contains(roleNameToDrop)) continue;
            throw new IllegalArgumentException("Cannot drop ROLE: " + roleNameToDrop + " as it is granted on role: " + role.name());
        }
    }

    private static void ensureUserDoesNotOwnForeignServers(Metadata metadata, String roleName) {
        ServersMetadata serversMetadata = metadata.custom("servers", ServersMetadata.EMPTY);
        ArrayList serversOwned = new ArrayList();
        serversMetadata.forEach(server -> {
            if (roleName.equals(server.owner())) {
                serversOwned.add(server.name());
            }
        });
        if (!serversOwned.isEmpty()) {
            throw new IllegalStateException(String.format(Locale.ENGLISH, "User '%s' cannot be dropped. %s '%s' needs to be dropped first.", roleName, "The user mappings for foreign servers", serversOwned));
        }
    }
}

