/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role;

import io.crate.role.GrantedRolesChange;
import io.crate.role.Privilege;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public class PrivilegesRequest
extends AcknowledgedRequest<PrivilegesRequest> {
    private final Collection<String> roleNames;
    private final Collection<Privilege> privileges;
    @Nullable
    private final GrantedRolesChange grantedRolesChange;

    PrivilegesRequest(Collection<String> roleNames, Collection<Privilege> privileges, @Nullable GrantedRolesChange grantedRolesChange) {
        this.roleNames = roleNames;
        this.privileges = privileges;
        this.grantedRolesChange = grantedRolesChange;
    }

    Collection<String> roleNames() {
        return this.roleNames;
    }

    public Collection<Privilege> privileges() {
        return this.privileges;
    }

    @Nullable
    public GrantedRolesChange rolePrivilege() {
        return this.grantedRolesChange;
    }

    public PrivilegesRequest(StreamInput in) throws IOException {
        super(in);
        int roleNamesSize = in.readVInt();
        this.roleNames = new ArrayList<String>(roleNamesSize);
        for (int i = 0; i < roleNamesSize; ++i) {
            this.roleNames.add(in.readString());
        }
        int privilegesSize = in.readVInt();
        this.privileges = new ArrayList<Privilege>(privilegesSize);
        for (int i = 0; i < privilegesSize; ++i) {
            this.privileges.add(new Privilege(in));
        }
        this.grantedRolesChange = in.getVersion().onOrAfter(Version.V_5_6_0) ? in.readOptionalWriteable(GrantedRolesChange::new) : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.roleNames.size());
        for (String roleName : this.roleNames) {
            out.writeString(roleName);
        }
        out.writeVInt(this.privileges.size());
        for (Privilege privilege : this.privileges) {
            privilege.writeTo(out);
        }
        if (out.getVersion().onOrAfter(Version.V_5_6_0)) {
            out.writeOptionalWriteable(this.grantedRolesChange);
        }
    }
}

