/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role.metadata;

import io.crate.role.Privilege;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentParser;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Deprecated(since="5.6.0")
public class UsersPrivilegesMetadata
extends AbstractNamedDiffable<Metadata.Custom>
implements Metadata.Custom {
    public static final String TYPE = "users_privileges";
    private final Map<String, Set<Privilege>> usersPrivileges;

    @VisibleForTesting
    public UsersPrivilegesMetadata() {
        this.usersPrivileges = new HashMap<String, Set<Privilege>>();
    }

    @VisibleForTesting
    public UsersPrivilegesMetadata(Map<String, Set<Privilege>> usersPrivileges) {
        this.usersPrivileges = usersPrivileges;
    }

    @Nullable
    public Set<Privilege> getUserPrivileges(String userName) {
        return this.usersPrivileges.get(userName);
    }

    private void createPrivileges(String userName, Set<Privilege> privileges) {
        this.usersPrivileges.put(userName, privileges);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsersPrivilegesMetadata that = (UsersPrivilegesMetadata)o;
        return Objects.equals(this.usersPrivileges, that.usersPrivileges);
    }

    public int hashCode() {
        return Objects.hash(this.usersPrivileges);
    }

    public UsersPrivilegesMetadata(StreamInput in) throws IOException {
        int numUsersPrivileges = in.readVInt();
        this.usersPrivileges = HashMap.newHashMap(numUsersPrivileges);
        for (int i = 0; i < numUsersPrivileges; ++i) {
            String userName = in.readString();
            int numPrivileges = in.readVInt();
            HashSet privileges = HashSet.newHashSet(numPrivileges);
            for (int j = 0; j < numPrivileges; ++j) {
                privileges.add(new Privilege(in));
            }
            this.usersPrivileges.put(userName, privileges);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.usersPrivileges.size());
        for (Map.Entry<String, Set<Privilege>> entry : this.usersPrivileges.entrySet()) {
            out.writeString(entry.getKey());
            out.writeVInt(entry.getValue().size());
            for (Privilege privilege : entry.getValue()) {
                privilege.writeTo(out);
            }
        }
    }

    public static UsersPrivilegesMetadata fromXContent(XContentParser parser) throws IOException {
        UsersPrivilegesMetadata metadata = new UsersPrivilegesMetadata();
        while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
            XContentParser.Token token;
            String userName = parser.currentName();
            Set<Privilege> privileges = metadata.getUserPrivileges(userName);
            if (privileges == null) {
                privileges = new HashSet<Privilege>();
                metadata.createPrivileges(userName, privileges);
            }
            if (parser.nextToken() != XContentParser.Token.START_ARRAY) continue;
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (token != XContentParser.Token.START_OBJECT) continue;
                privileges.add(Privilege.fromXContent(parser));
            }
        }
        return metadata;
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return EnumSet.of(Metadata.XContentContext.GATEWAY, Metadata.XContentContext.SNAPSHOT);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.V_3_0_1;
    }
}

