/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role.scalar;

import io.crate.data.Input;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import org.jetbrains.annotations.Nullable;

public class UserFunction
extends Scalar<String, Object> {
    public static final String CURRENT_USER_FUNCTION_NAME = "current_user";
    public static final String SESSION_USER_FUNCTION_NAME = "session_user";

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder(CURRENT_USER_FUNCTION_NAME, FunctionType.SCALAR).returnType(DataTypes.STRING.getTypeSignature()).build(), UserFunction::new);
        builder.add(Signature.builder(SESSION_USER_FUNCTION_NAME, FunctionType.SCALAR).returnType(DataTypes.STRING.getTypeSignature()).build(), UserFunction::new);
    }

    public UserFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        assert (args.length == 0) : "number of args must be 0";
        return txnCtx.sessionSettings().userName();
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, @Nullable TransactionContext txnCtx, NodeContext nodeCtx) {
        if (txnCtx == null) {
            return Literal.NULL;
        }
        return Literal.of(txnCtx.sessionSettings().userName());
    }
}

