/*
 * Decompiled with CFR 0.152.
 */
package io.crate.session;

import io.crate.analyze.AnalyzedStatement;
import io.crate.session.Session;
import io.crate.sql.tree.Statement;
import io.crate.types.DataType;

public class PreparedStmt {
    private final AnalyzedStatement analyzedStatement;
    private final Statement parsedStatement;
    private final String rawStatement;
    private final DataType<?>[] describedParameterTypes;
    private final Session.TimeoutToken timeoutToken;

    PreparedStmt(Statement parsedStatement, AnalyzedStatement analyzedStatement, String query, DataType<?>[] parameterTypes, Session.TimeoutToken timeoutToken) {
        this.parsedStatement = parsedStatement;
        this.analyzedStatement = analyzedStatement;
        this.rawStatement = query;
        this.describedParameterTypes = parameterTypes;
        this.timeoutToken = timeoutToken;
    }

    public AnalyzedStatement analyzedStatement() {
        return this.analyzedStatement;
    }

    Statement parsedStatement() {
        return this.parsedStatement;
    }

    DataType<?>[] parameterTypes() {
        return this.describedParameterTypes;
    }

    DataType<?> getEffectiveParameterType(int idx) {
        if (idx >= this.describedParameterTypes.length) {
            throw new IllegalArgumentException("Requested parameter index exceeds the number of parameters: " + idx);
        }
        return this.describedParameterTypes[idx];
    }

    public String rawStatement() {
        return this.rawStatement;
    }

    public Session.TimeoutToken timeoutToken() {
        return this.timeoutToken;
    }
}

