/*
 * Decompiled with CFR 0.152.
 */
package io.crate.session;

import io.crate.data.BatchIterator;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.exceptions.SQLExceptions;
import io.crate.session.ResultReceiver;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class RowConsumerToResultReceiver
implements RowConsumer {
    private static final Logger LOGGER = LogManager.getLogger(RowConsumerToResultReceiver.class);
    private final CompletableFuture<?> completionFuture = new CompletableFuture();
    private ResultReceiver<?> resultReceiver;
    private int maxRows;
    private int rowCount = 0;
    private CompletableFuture<BatchIterator<Row>> suspendedIt = new CompletableFuture();
    private boolean waitingForWrite = false;

    public RowConsumerToResultReceiver(ResultReceiver<?> resultReceiver, int maxRows, Consumer<Throwable> onCompletion) {
        this.resultReceiver = resultReceiver;
        this.maxRows = maxRows;
        this.completionFuture.whenComplete((object, err) -> onCompletion.accept((Throwable)err));
    }

    public void accept(BatchIterator<Row> iterator, @Nullable Throwable failure) {
        if (failure == null) {
            this.consumeIt(iterator);
        } else {
            if (iterator != null) {
                iterator.close();
            }
            this.completionFuture.completeExceptionally(failure);
            this.resultReceiver.fail(failure);
        }
    }

    public CompletableFuture<?> completionFuture() {
        return this.completionFuture;
    }

    private void consumeIt(BatchIterator<Row> iterator) {
        try {
            CompletableFuture nextBatch;
            while (true) {
                if (iterator.moveNext()) {
                    if (this.rowCount > 0 && this.maxRows > 0 && this.rowCount % this.maxRows == 0) {
                        this.suspendedIt.complete(iterator);
                        this.resultReceiver.batchFinished();
                        return;
                    }
                    ++this.rowCount;
                    CompletableFuture<Void> writeFuture = this.resultReceiver.setNextRow((Row)iterator.currentElement());
                    if (writeFuture == null) continue;
                    LOGGER.trace("Suspended execution after {} rows as the receiver is not writable anymore", (Object)this.rowCount);
                    this.waitingForWrite = true;
                    writeFuture.thenRun(() -> {
                        LOGGER.trace("Resume execution after {} rows", (Object)this.rowCount);
                        this.waitingForWrite = false;
                        this.rowCount = 0;
                        this.consumeIt(iterator);
                    });
                    return;
                }
                if (iterator.allLoaded()) {
                    this.completionFuture.complete(null);
                    iterator.close();
                    this.resultReceiver.allFinished();
                    return;
                }
                nextBatch = iterator.loadNextBatch().toCompletableFuture();
                if (!nextBatch.isDone()) break;
                if (!nextBatch.isCompletedExceptionally()) continue;
                nextBatch.join();
            }
            nextBatch.whenComplete((object, f) -> {
                if (f == null) {
                    this.consumeIt(iterator);
                } else {
                    Throwable t = SQLExceptions.unwrap(f);
                    iterator.close();
                    this.completionFuture.completeExceptionally(t);
                    this.resultReceiver.fail(t);
                }
            });
            return;
        }
        catch (Throwable t) {
            iterator.close();
            this.completionFuture.completeExceptionally(t);
            this.resultReceiver.fail(t);
            return;
        }
    }

    public void closeAndFinishIfSuspended() {
        this.suspendedIt.whenComplete((it, throwable) -> {
            it.close();
            this.completionFuture.complete(null);
        });
    }

    public boolean suspended() {
        return this.suspendedIt.isDone();
    }

    @VisibleForTesting
    public boolean waitingForWrite() {
        return this.waitingForWrite;
    }

    public void replaceResultReceiver(ResultReceiver<?> resultReceiver, int maxRows) {
        if (!this.resultReceiver.completionFuture().isDone()) {
            this.resultReceiver.allFinished();
        }
        this.rowCount = 0;
        this.resultReceiver = resultReceiver;
        this.maxRows = maxRows;
    }

    public void resume() {
        assert (this.suspended()) : "resume must only be called if suspended() returned true";
        BatchIterator<Row> it = null;
        try {
            it = this.suspendedIt.join();
            this.suspendedIt = new CompletableFuture();
            this.resultReceiver.setNextRow((Row)it.currentElement());
            ++this.rowCount;
            this.consumeIt(it);
        }
        catch (Throwable t) {
            if (it != null) {
                it.close();
            }
            this.completionFuture.completeExceptionally(t);
            this.resultReceiver.fail(t);
        }
    }

    public String toString() {
        return "RowConsumerToResultReceiver{resultReceiver=" + String.valueOf(this.resultReceiver) + ", maxRows=" + this.maxRows + ", rowCount=" + this.rowCount + ", activeIt=" + String.valueOf(this.suspendedIt) + "}";
    }
}

