/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.Streamer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class MostCommonValues<T> {
    private final List<T> values;
    private final double[] frequencies;

    public static <T> MostCommonValues<T> empty() {
        return new MostCommonValues(List.of(), new double[0]);
    }

    public MostCommonValues(List<T> values, double[] frequencies) {
        assert (values.size() == frequencies.length) : "values and frequencies must have the same number of items";
        this.values = values;
        this.frequencies = frequencies;
    }

    public MostCommonValues(Streamer<T> valueStreamer, StreamInput in) throws IOException {
        int numValues = in.readVInt();
        this.values = new ArrayList<T>();
        this.frequencies = new double[numValues];
        for (int i = 0; i < numValues; ++i) {
            this.values.add(valueStreamer.readValueFrom(in));
            this.frequencies[i] = in.readDouble();
        }
    }

    public void writeTo(Streamer<T> valueStreamer, StreamOutput out) throws IOException {
        out.writeVInt(this.values.size());
        for (int i = 0; i < this.values.size(); ++i) {
            valueStreamer.writeValueTo(out, this.values.get(i));
            out.writeDouble(this.frequencies[i]);
        }
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public int length() {
        return this.values.size();
    }

    public T value(int index) {
        return this.values.get(index);
    }

    public double frequency(int index) {
        return this.frequencies[index];
    }

    public List<T> values() {
        return this.values;
    }

    public double[] frequencies() {
        return this.frequencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MostCommonValues that = (MostCommonValues)o;
        if (!Objects.equals(this.values, that.values)) {
            return false;
        }
        return Arrays.equals(this.frequencies, that.frequencies);
    }

    public int hashCode() {
        int result = Objects.hash(this.values);
        result = 31 * result + Arrays.hashCode(this.frequencies);
        return result;
    }
}

