/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.Streamer;
import java.io.EOFException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.Memory;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;

public class SketchStreamer<T>
extends ArrayOfItemsSerDe<T> {
    private final Streamer<T> streamer;

    public SketchStreamer(Streamer<T> streamer) {
        this.streamer = streamer;
    }

    public byte[] serializeToByteArray(T item) {
        throw new UnsupportedOperationException();
    }

    public byte[] serializeToByteArray(T[] items) {
        BytesStreamOutput out = new BytesStreamOutput();
        try {
            for (T v : items) {
                this.streamer.writeValueTo(out, v);
            }
            byte[] throwable = out.bytes().toBytesRef().bytes;
            out.close();
            return throwable;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public T[] deserializeFromMemory(Memory mem, int numItems) {
        throw new UnsupportedOperationException();
    }

    public T[] deserializeFromMemory(Memory mem, long offsetBytes, int numItems) {
        T[] TArray;
        MemoryStreamInput in = new MemoryStreamInput(mem);
        try {
            ArrayList<T> values = new ArrayList<T>();
            for (int i = 0; i < numItems; ++i) {
                values.add(this.streamer.readValueFrom(in));
            }
            TArray = values.toArray(Object[]::new);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        in.close();
        return TArray;
    }

    public int sizeOf(T item) {
        throw new UnsupportedOperationException();
    }

    public int sizeOf(Memory mem, long offsetBytes, int numItems) {
        throw new UnsupportedOperationException();
    }

    public String toString(T item) {
        return item.toString();
    }

    public Class<?> getClassOfT() {
        throw new UnsupportedOperationException();
    }

    private static class MemoryStreamInput
    extends StreamInput {
        final Buffer buffer;

        private MemoryStreamInput(Memory memory) {
            this.buffer = memory.asBuffer();
        }

        @Override
        public byte readByte() throws IOException {
            return this.buffer.getByte();
        }

        @Override
        public void readBytes(byte[] b, int offset, int len) throws IOException {
            this.buffer.getByteArray(b, offset, len);
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public int read() throws IOException {
            return this.buffer.getInt();
        }

        @Override
        public int available() throws IOException {
            return 0;
        }

        @Override
        protected void ensureCanReadBytes(int length) throws EOFException {
        }
    }
}

