/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.common.unit.TimeValue;
import io.crate.data.Row;
import io.crate.session.BaseResultReceiver;
import io.crate.session.Session;
import io.crate.session.Sessions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class TableStatsService
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(TableStatsService.class);
    public static final Setting<TimeValue> STATS_SERVICE_REFRESH_INTERVAL_SETTING = Setting.timeSetting("stats.service.interval", TimeValue.timeValueHours((long)24L), Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Exposed);
    public static final Setting<ByteSizeValue> STATS_SERVICE_THROTTLING_SETTING = Setting.byteSizeSetting("stats.service.max_bytes_per_sec", new ByteSizeValue(40L, ByteSizeUnit.MB), Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Exposed);
    static final String STMT = "ANALYZE";
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final Sessions sessions;
    private Session session;
    @VisibleForTesting
    volatile TimeValue refreshInterval;
    @VisibleForTesting
    volatile Scheduler.ScheduledCancellable scheduledRefresh;

    @Inject
    public TableStatsService(Settings settings, ThreadPool threadPool, ClusterService clusterService, Sessions sessions) {
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.sessions = sessions;
        this.refreshInterval = STATS_SERVICE_REFRESH_INTERVAL_SETTING.get(settings);
        this.scheduledRefresh = this.scheduleNextRefresh(this.refreshInterval);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(STATS_SERVICE_REFRESH_INTERVAL_SETTING, this::setRefreshInterval);
    }

    @Override
    public void run() {
        this.updateStats();
    }

    public void updateStats() {
        if (this.clusterService.localNode() == null) {
            LOGGER.debug("Could not retrieve table stats. localNode is not fully available yet.");
            return;
        }
        if (this.clusterService.state().nodes().getMinNodeVersion().before(Version.V_5_7_0)) {
            LOGGER.debug("Could not retrieve table stats.  Cluster not fully updated yet");
            return;
        }
        if (!this.clusterService.state().nodes().isLocalNodeElectedMaster()) {
            return;
        }
        try {
            BaseResultReceiver resultReceiver = new BaseResultReceiver();
            resultReceiver.completionFuture().whenComplete((res, err) -> {
                this.scheduledRefresh = this.scheduleNextRefresh(this.refreshInterval);
                if (err != null) {
                    LOGGER.error("Error running periodic ANALYZE", err);
                }
            });
            if (this.session == null) {
                this.session = this.sessions.newSystemSession();
            }
            this.session.quickExec(STMT, resultReceiver, Row.EMPTY);
        }
        catch (Throwable t) {
            LOGGER.error("error retrieving table stats", t);
        }
    }

    @Nullable
    private Scheduler.ScheduledCancellable scheduleNextRefresh(TimeValue refreshInterval) {
        if (refreshInterval.millis() > 0L) {
            return this.threadPool.schedule(this, refreshInterval, "refresh");
        }
        return null;
    }

    private void setRefreshInterval(TimeValue newRefreshInterval) {
        if (this.scheduledRefresh != null) {
            this.scheduledRefresh.cancel();
            this.scheduledRefresh = null;
        }
        this.refreshInterval = newRefreshInterval;
        this.scheduledRefresh = this.scheduleNextRefresh(newRefreshInterval);
    }
}

