/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.settings.SessionSettings;
import io.crate.sql.tree.ColumnDefinition;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.Expression;
import io.crate.statistics.ColumnStatsSupport;
import io.crate.types.DataTypes;
import io.crate.types.StorageSupport;
import io.crate.types.TypeSignature;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.jetbrains.annotations.Nullable;

public abstract class DataType<T>
implements Comparable<DataType<?>>,
Writeable,
Comparator<T>,
Accountable {
    public abstract int id();

    protected abstract Precedence precedence();

    public abstract String getName();

    public abstract Streamer<T> streamer();

    public T implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        throw new UnsupportedOperationException("The cast operation for type `" + this.getName() + "` is not supported.");
    }

    public T explicitCast(Object value, SessionSettings sessionSettings) throws IllegalArgumentException, ClassCastException {
        return this.implicitCast(value);
    }

    public T valueForInsert(T value) {
        return value;
    }

    public abstract T sanitizeValue(Object var1);

    @Nullable
    public T sanitizeValueLenient(Object value) {
        try {
            return this.sanitizeValue(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public TypeSignature getTypeSignature() {
        return new TypeSignature(this.getName());
    }

    public List<DataType<?>> getTypeParameters() {
        return Collections.emptyList();
    }

    public boolean precedes(DataType<?> that) {
        int thatOrdinal;
        int thisOrdinal = this.precedence().ordinal();
        if (thisOrdinal == (thatOrdinal = that.precedence().ordinal())) {
            Integer thisPrecision = this.numericPrecision();
            Integer thatPrecision = that.numericPrecision();
            if (thisPrecision == null && thatPrecision == null) {
                Integer thisLength = this.characterMaximumLength();
                Integer thatLength = that.characterMaximumLength();
                if (thisLength == null) {
                    return true;
                }
                if (thatLength == null) {
                    return false;
                }
                return thisLength > thatLength;
            }
            if (thisPrecision == null) {
                return true;
            }
            if (thatPrecision == null) {
                return false;
            }
            return thisPrecision > thatPrecision;
        }
        return thisOrdinal > thatOrdinal;
    }

    public boolean isConvertableTo(DataType<?> other, boolean explicitCast) {
        if (this.equals(other)) {
            return true;
        }
        Set<Integer> possibleConversions = DataTypes.ALLOWED_CONVERSIONS.get(this.id());
        if (possibleConversions == null) {
            return false;
        }
        return possibleConversions.contains(other.id());
    }

    DataType<?> merge(DataType<?> other) {
        assert (this.id() == other.id() || this.precedes(other)) : "'this' precedes 'other' or they must be the same type";
        if (other.isConvertableTo(this, false)) {
            return this;
        }
        throw new IllegalArgumentException("'" + String.valueOf(other) + "' is not convertible to '" + String.valueOf(this) + "'");
    }

    public int hashCode() {
        return this.id();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataType)) {
            return false;
        }
        DataType that = (DataType)o;
        return this.id() == that.id();
    }

    @Override
    public int compareTo(DataType<?> o) {
        return Integer.compare(this.id(), o.id());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
    }

    public String toString() {
        return this.getName();
    }

    @Nullable
    public StorageSupport<? super T> storageSupport() {
        return null;
    }

    public final StorageSupport<? super T> storageSupportSafe() {
        StorageSupport<T> storageSupport = this.storageSupport();
        if (storageSupport == null) {
            throw new UnsupportedOperationException("Type `" + this.getName() + "` does not support storage");
        }
        return storageSupport;
    }

    public final ValueIndexer<? super T> valueIndexer(RelationName table, Reference ref, Function<ColumnIdent, Reference> getRef) {
        StorageSupport<T> storageSupport = this.storageSupportSafe();
        return storageSupport.valueIndexer(table, ref, getRef);
    }

    public ColumnType<Expression> toColumnType(@Nullable Supplier<List<ColumnDefinition<Expression>>> convertChildColumn) {
        assert (this.getTypeParameters().isEmpty()) : "If the type parameters aren't empty, `" + this.getClass().getSimpleName() + "` must override `toColumnType`";
        return new ColumnType(this.getName());
    }

    public Integer characterMaximumLength() {
        return null;
    }

    @Nullable
    public Integer numericPrecision() {
        return null;
    }

    public abstract long valueBytes(@Nullable T var1);

    public long ramBytesUsed() {
        return 0L;
    }

    public void addMappingOptions(Map<String, Object> mapping) {
    }

    public ColumnStatsSupport<T> columnStatsSupport() {
        throw new UnsupportedOperationException("Datatype " + String.valueOf(this) + " does not support column stats");
    }

    public ColumnPolicy columnPolicy() {
        return ColumnPolicy.STRICT;
    }

    public static enum Precedence {
        NOT_SUPPORTED,
        UNDEFINED,
        STRING,
        CHARACTER,
        BYTE,
        BOOLEAN,
        SHORT,
        TIMETZ,
        INTEGER,
        REGPROC,
        REGCLASS,
        INTERVAL,
        DATE,
        TIMESTAMP_WITH_TIME_ZONE,
        TIMESTAMP,
        LONG,
        IP,
        FLOAT,
        DOUBLE,
        NUMERIC,
        ARRAY,
        TABLE,
        GEO_POINT,
        OBJECT,
        UNCHECKED_OBJECT,
        GEO_SHAPE,
        CUSTOM;

    }
}

