/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.statistics.ColumnStatsSupport;
import io.crate.types.DataType;
import io.crate.types.FixedWidthType;
import io.crate.types.TimestampType;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DateType
extends DataType<Long>
implements FixedWidthType,
Streamer<Long> {
    public static final int ID = 24;
    public static final DateType INSTANCE = new DateType();
    public static final int TYPE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(Long.class);

    @Override
    public int id() {
        return 24;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.DATE;
    }

    @Override
    public String getName() {
        return "date";
    }

    @Override
    public Streamer<Long> streamer() {
        return this;
    }

    @Override
    public Long implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        long longVal;
        block12: {
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                String stringVal = (String)value;
                try {
                    TemporalAccessor dt = TimestampType.TIMESTAMP_PARSER.parseBest(stringVal, LocalDateTime::from, LocalDate::from);
                    LocalDate localDate = LocalDate.from(dt);
                    return localDate.atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli();
                }
                catch (DateTimeParseException ex) {
                    try {
                        longVal = Long.parseLong(stringVal);
                        break block12;
                    }
                    catch (NumberFormatException e) {
                        throw new ClassCastException("Can't cast '" + String.valueOf(value) + "' to " + this.getName());
                    }
                }
            }
            if (value instanceof Double) {
                Double d = (Double)value;
                longVal = ((Number)(d * 1000.0)).longValue();
            } else if (value instanceof Float) {
                Float f = (Float)value;
                longVal = ((Number)Float.valueOf(f.floatValue() * 1000.0f)).longValue();
            } else if (value instanceof Number) {
                Number number = (Number)value;
                longVal = number.longValue();
            } else {
                throw new ClassCastException("Can't cast '" + String.valueOf(value) + "' to " + this.getName());
            }
        }
        long epochDay = longVal / 1000L / 86400L;
        LocalDate localDate = LocalDate.ofEpochDay(epochDay);
        return localDate.atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli();
    }

    @Override
    public Long sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.longValue();
        }
        return (Long)value;
    }

    @Override
    public int compare(Long o1, Long o2) {
        return o1.compareTo(o2);
    }

    @Override
    public Long readValueFrom(StreamInput in) throws IOException {
        return in.readBoolean() ? null : Long.valueOf(in.readLong());
    }

    @Override
    public void writeValueTo(StreamOutput out, Long v) throws IOException {
        out.writeBoolean(v == null);
        if (v != null) {
            out.writeLong(v);
        }
    }

    @Override
    public int fixedSize() {
        return TYPE_SIZE;
    }

    @Override
    public long valueBytes(Long value) {
        return TYPE_SIZE;
    }

    @Override
    public ColumnStatsSupport<Long> columnStatsSupport() {
        return ColumnStatsSupport.singleValued(Long.class, this);
    }
}

