/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.common.collections.Lists;
import io.crate.execution.dml.IpIndexer;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.statistics.ColumnStatsSupport;
import io.crate.types.DataType;
import io.crate.types.EqQuery;
import io.crate.types.StorageSupport;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.InetAddresses;

public class IpType
extends DataType<String>
implements Streamer<String> {
    public static final int ID = 5;
    public static final IpType INSTANCE = new IpType();
    private static final StorageSupport<String> STORAGE = new StorageSupport<String>(true, false, (EqQuery)new EqQuery<String>(){

        @Override
        public Query termQuery(String field, String value, boolean hasDocValues, boolean isIndexed) {
            if (isIndexed) {
                return InetAddressPoint.newExactQuery((String)field, (InetAddress)InetAddresses.forString(value));
            }
            assert (hasDocValues) : "hasDocValues must be true for Ip types since 'columnstore=false' is not supported.";
            return SortedSetDocValuesField.newSlowExactQuery((String)field, (BytesRef)new BytesRef(InetAddressPoint.encode((InetAddress)InetAddresses.forString(value))));
        }

        @Override
        public Query rangeQuery(String field, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isIndexed) {
            InetAddress inclusiveUpper;
            InetAddress inclusiveLower;
            if (lowerTerm == null) {
                inclusiveLower = InetAddressPoint.MIN_VALUE;
            } else {
                InetAddress lowerAddress = InetAddresses.forString(lowerTerm);
                InetAddress inetAddress = inclusiveLower = includeLower ? lowerAddress : InetAddressPoint.nextUp((InetAddress)lowerAddress);
            }
            if (upperTerm == null) {
                inclusiveUpper = InetAddressPoint.MAX_VALUE;
            } else {
                InetAddress upperAddress = InetAddresses.forString(upperTerm);
                InetAddress inetAddress = inclusiveUpper = includeUpper ? upperAddress : InetAddressPoint.nextDown((InetAddress)upperAddress);
            }
            if (isIndexed) {
                return InetAddressPoint.newRangeQuery((String)field, (InetAddress)inclusiveLower, (InetAddress)inclusiveUpper);
            }
            assert (hasDocValues) : "hasDocValues must be true for Ip types since 'columnstore=false' is not supported.";
            return SortedSetDocValuesField.newSlowRangeQuery((String)field, (BytesRef)new BytesRef(InetAddressPoint.encode((InetAddress)inclusiveLower)), (BytesRef)new BytesRef(InetAddressPoint.encode((InetAddress)inclusiveUpper)), (boolean)true, (boolean)true);
        }

        @Override
        public Query termsQuery(String field, List<String> nonNullValues, boolean hasDocValues, boolean isIndexed) {
            if (isIndexed) {
                return InetAddressPoint.newSetQuery((String)field, (InetAddress[])((InetAddress[])nonNullValues.stream().map(InetAddresses::forString).toArray(InetAddress[]::new)));
            }
            assert (hasDocValues) : "hasDocValues must be true for Ip types since 'columnstore=false' is not supported.";
            return SortedSetDocValuesField.newSlowSetQuery((String)field, (Collection)Lists.map(nonNullValues, v -> new BytesRef(InetAddressPoint.encode((InetAddress)InetAddresses.forString(v)))));
        }
    }){

        @Override
        public ValueIndexer<String> valueIndexer(RelationName table, Reference ref, Function<ColumnIdent, Reference> getRef) {
            return new IpIndexer(ref);
        }
    };

    @Override
    public int id() {
        return 5;
    }

    @Override
    public String getName() {
        return "ip";
    }

    @Override
    public Streamer<String> streamer() {
        return this;
    }

    @Override
    public String implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String str = (String)value;
            this.validate(str);
            return (String)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            long longIp = number.longValue();
            if (longIp < 0L) {
                throw new IllegalArgumentException("Failed to convert long value: " + longIp + " to ipv4 address");
            }
            return IpType.longToIp(longIp);
        }
        throw new ClassCastException("Can't cast '" + String.valueOf(value) + "' to " + this.getName());
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.IP;
    }

    @Override
    public String sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        this.validate((String)value);
        return (String)value;
    }

    private static String longToIp(long longIp) {
        int octet3 = (int)((longIp >> 24) % 256L);
        int octet2 = (int)((longIp >> 16) % 256L);
        int octet1 = (int)((longIp >> 8) % 256L);
        int octet0 = (int)(longIp % 256L);
        return octet3 + "." + octet2 + "." + octet1 + "." + octet0;
    }

    private void validate(String ip) {
        if (!InetAddresses.isInetAddress(ip)) {
            throw new IllegalArgumentException("Failed to validate ip [" + ip + "], not a valid ipv4 address");
        }
    }

    @Override
    public int compare(String val1, String val2) {
        byte[] ip1 = InetAddresses.ipStringToBytes(val1);
        byte[] ip2 = InetAddresses.ipStringToBytes(val2);
        return Arrays.compareUnsigned(ip1, ip2);
    }

    @Override
    public String readValueFrom(StreamInput in) throws IOException {
        return in.readOptionalString();
    }

    @Override
    public void writeValueTo(StreamOutput out, String v) throws IOException {
        out.writeOptionalString(v);
    }

    @Override
    public StorageSupport<String> storageSupport() {
        return STORAGE;
    }

    @Override
    public ColumnStatsSupport<String> columnStatsSupport() {
        return ColumnStatsSupport.singleValued(String.class, this);
    }

    @Override
    public long valueBytes(String value) {
        return RamUsageEstimator.sizeOf((String)value);
    }
}

