/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.protocols.postgres.types.PGArray;
import io.crate.protocols.postgres.types.PgOidVectorType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.shape.impl.PointImpl;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.PGobject;

public class ResultSetParser {
    public static Object getObject(ResultSet resultSet, int i, String typeName) throws SQLException {
        List<Object> value;
        int columnIndex = i + 1;
        switch (typeName) {
            case "int2": {
                Integer intValue = (Integer)resultSet.getObject(columnIndex);
                if (intValue == null) {
                    return null;
                }
                value = intValue.shortValue();
                break;
            }
            case "_char": {
                Array array = resultSet.getArray(columnIndex);
                if (array == null) {
                    return null;
                }
                ArrayList<Byte> elements = new ArrayList<Byte>();
                for (Object o : (Object[])array.getArray()) {
                    elements.add(Byte.parseByte((String)o));
                }
                return elements;
            }
            case "oidvector": {
                String textval = resultSet.getString(columnIndex);
                if (textval == null) {
                    return null;
                }
                return PgOidVectorType.listFromOidVectorString(textval);
            }
            case "char": {
                String str = resultSet.getString(columnIndex);
                if (str == null) {
                    return null;
                }
                return str;
            }
            case "byte": {
                value = resultSet.getByte(columnIndex);
                break;
            }
            case "_json": 
            case "_jsonb": {
                Array array = resultSet.getArray(columnIndex);
                if (array == null) {
                    return null;
                }
                ArrayList<Object> jsonObjects = new ArrayList<Object>();
                for (Object item : (Object[])array.getArray()) {
                    jsonObjects.add(ResultSetParser.jsonToObject((String)item));
                }
                value = jsonObjects;
                break;
            }
            case "json": 
            case "jsonb": {
                String json = resultSet.getString(columnIndex);
                value = ResultSetParser.jsonToObject(json);
                break;
            }
            case "point": {
                PGpoint pGpoint = resultSet.getObject(columnIndex, PGpoint.class);
                value = new PointImpl(pGpoint.x, pGpoint.y, (SpatialContext)JtsSpatialContext.GEO);
                break;
            }
            case "record": {
                value = resultSet.getObject(columnIndex, PGobject.class).getValue();
                break;
            }
            case "_bit": {
                String pgBitStringArray = resultSet.getString(columnIndex);
                if (pgBitStringArray == null) {
                    return null;
                }
                byte[] bytes = pgBitStringArray.getBytes(StandardCharsets.UTF_8);
                ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
                value = PGArray.BIT_ARRAY.readTextValue(buf, bytes.length);
                buf.release();
                break;
            }
            default: {
                value = resultSet.getObject(columnIndex);
            }
        }
        if (value instanceof Timestamp) {
            value = ((Timestamp)((Object)value)).getTime();
        } else if (value instanceof Array) {
            value = Arrays.asList((Object[])((Array)((Object)value)).getArray());
        }
        return value;
    }

    private static Object jsonToObject(String json) {
        try {
            if (json != null) {
                byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
                XContentParser parser = JsonXContent.JSON_XCONTENT.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, bytes);
                if (bytes.length >= 1 && bytes[0] == 91) {
                    parser.nextToken();
                    return parser.list();
                }
                return parser.mapOrdered();
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

