/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.execution.dml.ValueIndexer;
import io.crate.expression.reference.doc.lucene.SourceParser;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.types.EqQuery;
import java.util.function.Function;
import org.elasticsearch.Version;
import org.jetbrains.annotations.Nullable;

public abstract class StorageSupport<T> {
    private final boolean docValuesDefault;
    private final boolean supportsDocValuesOff;
    @Nullable
    private final EqQuery<T> eqQuery;

    StorageSupport(StorageSupport<T> base) {
        this(base.docValuesDefault, base.supportsDocValuesOff, base.eqQuery);
    }

    StorageSupport(boolean docValuesDefault, boolean supportsDocValuesOff, @Nullable EqQuery<T> eqQuery) {
        this.docValuesDefault = docValuesDefault;
        this.supportsDocValuesOff = supportsDocValuesOff;
        this.eqQuery = eqQuery;
    }

    public boolean getComputedDocValuesDefault(@Nullable IndexType indexType) {
        return this.docValuesDefault && indexType != IndexType.FULLTEXT;
    }

    public abstract ValueIndexer<? super T> valueIndexer(RelationName var1, Reference var2, Function<ColumnIdent, Reference> var3);

    public T decode(ColumnIdent column, SourceParser sourceParser, Version tableVersion, byte[] bytes) {
        throw new UnsupportedOperationException("decodeFromBytes not supported");
    }

    public T decode(long input) {
        throw new UnsupportedOperationException("decodeFromLong not supported");
    }

    public T decode(int input) {
        throw new UnsupportedOperationException("decodeFromInt not supported");
    }

    public boolean retrieveFromStoredFields() {
        return false;
    }

    public boolean docValuesDefault() {
        return this.docValuesDefault;
    }

    public boolean supportsDocValuesOff() {
        return this.supportsDocValuesOff;
    }

    @Nullable
    public EqQuery<T> eqQuery() {
        return this.eqQuery;
    }
}

