/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import io.crate.common.CheckedFunction;
import io.crate.exceptions.ArrayViaDocValuesUnsupportedException;
import io.crate.exceptions.InvalidArgumentException;
import io.crate.exceptions.InvalidColumnNameException;
import io.crate.exceptions.JobKilledException;
import io.crate.exceptions.OperationOnInaccessibleRelationException;
import io.crate.exceptions.RelationAlreadyExists;
import io.crate.exceptions.RelationUnknown;
import io.crate.exceptions.RoleAlreadyExistsException;
import io.crate.exceptions.RoleUnknownException;
import io.crate.exceptions.SQLExceptions;
import io.crate.exceptions.SchemaUnknownException;
import io.crate.exceptions.TaskMissing;
import io.crate.exceptions.UnauthorizedException;
import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.exceptions.UserDefinedFunctionAlreadyExistsException;
import io.crate.exceptions.UserDefinedFunctionUnknownException;
import io.crate.exceptions.VersioningValidationException;
import io.crate.fdw.ServerAlreadyExistsException;
import io.crate.fdw.UserMappingAlreadyExists;
import io.crate.protocols.postgres.PGErrorStatus;
import io.crate.replication.logical.exceptions.MissingShardOperationsException;
import io.crate.replication.logical.exceptions.PublicationAlreadyExistsException;
import io.crate.replication.logical.exceptions.PublicationUnknownException;
import io.crate.replication.logical.exceptions.SubscriptionAlreadyExistsException;
import io.crate.replication.logical.exceptions.SubscriptionUnknownException;
import io.crate.rest.action.HttpErrorStatus;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.NoSuchNodeException;
import org.elasticsearch.action.PrimaryMissingActionException;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.admin.indices.alias.AliasesNotFoundException;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.replication.ReplicationOperation;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.cluster.IncompatibleClusterStateVersionException;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.coordination.CoordinationStateRejectedException;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.coordination.NodeHealthCheckFailureException;
import org.elasticsearch.cluster.metadata.ProcessClusterEventTimeoutException;
import org.elasticsearch.cluster.routing.IllegalShardRoutingStateException;
import org.elasticsearch.cluster.routing.RoutingException;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.blobstore.BlobStoreException;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.io.stream.NotSerializableExceptionWrapper;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.settings.NoClassSettingsException;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.util.CancellableThreads;
import org.elasticsearch.common.util.concurrent.UncategorizedExecutionException;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.env.ShardLockObtainFailedException;
import org.elasticsearch.gateway.GatewayException;
import org.elasticsearch.http.BindHttpException;
import org.elasticsearch.http.HttpException;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.DocumentSourceMissingException;
import org.elasticsearch.index.engine.EngineCreationFailureException;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.FlushFailedEngineException;
import org.elasticsearch.index.engine.RecoveryEngineException;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.engine.SnapshotFailedEngineException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.mapper.MapperException;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.StrictDynamicMappingException;
import org.elasticsearch.index.seqno.RetentionLeaseAlreadyExistsException;
import org.elasticsearch.index.seqno.RetentionLeaseInvalidRetainingSeqNoException;
import org.elasticsearch.index.seqno.RetentionLeaseNotFoundException;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardNotRecoveringException;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardRecoveringException;
import org.elasticsearch.index.shard.IndexShardRecoveryException;
import org.elasticsearch.index.shard.IndexShardRelocatedException;
import org.elasticsearch.index.shard.IndexShardStartedException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.index.shard.ShardNotInPrimaryModeException;
import org.elasticsearch.index.snapshots.IndexShardRestoreException;
import org.elasticsearch.index.snapshots.IndexShardRestoreFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import org.elasticsearch.index.translog.TranslogCorruptedException;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.index.translog.TruncatedTranslogException;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.indices.IndexCreationException;
import org.elasticsearch.indices.IndexPrimaryShardNotAllocatedException;
import org.elasticsearch.indices.IndexTemplateMissingException;
import org.elasticsearch.indices.InvalidAliasNameException;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.indices.InvalidIndexTemplateException;
import org.elasticsearch.indices.InvalidTypeNameException;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.indices.recovery.DelayRecoveryException;
import org.elasticsearch.indices.recovery.PeerRecoveryNotFound;
import org.elasticsearch.indices.recovery.RecoverFilesRecoveryException;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.repositories.RepositoryVerificationException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import org.elasticsearch.snapshots.InvalidSnapshotNameException;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotRestoreException;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.transport.ActionTransportException;
import org.elasticsearch.transport.BindTransportException;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.NodeDisconnectedException;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.NodeShouldNotConnectException;
import org.elasticsearch.transport.NotSerializableTransportException;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.ResponseHandlerFailureTransportException;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportSerializationException;

public class ElasticsearchException
extends RuntimeException
implements Writeable {
    private static final Version UNKNOWN_VERSION_ADDED = Version.fromId(0);
    private static final String INDEX_METADATA_KEY = "es.index";
    private static final String INDEX_METADATA_KEY_UUID = "es.index_uuid";
    private static final String SHARD_METADATA_KEY = "es.shard";
    private static final String RESOURCE_METADATA_TYPE_KEY = "es.resource.type";
    private static final String RESOURCE_METADATA_ID_KEY = "es.resource.id";
    private static final Map<Integer, CheckedFunction<StreamInput, ? extends ElasticsearchException, IOException>> ID_TO_SUPPLIER = Collections.unmodifiableMap(Arrays.stream(ElasticsearchExceptionHandle.values()).collect(Collectors.toMap(e -> e.id, e -> e.constructor)));
    private static final Map<Class<? extends ElasticsearchException>, ElasticsearchExceptionHandle> CLASS_TO_ELASTICSEARCH_EXCEPTION_HANDLE = Collections.unmodifiableMap(Arrays.stream(ElasticsearchExceptionHandle.values()).collect(Collectors.toMap(e -> e.exceptionClass, e -> e)));
    private final Map<String, List<String>> metadata = new HashMap<String, List<String>>();
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public ElasticsearchException(Throwable cause) {
        super(cause);
    }

    public ElasticsearchException(String msg, Object ... args) {
        super(LoggerMessageFormat.format(msg, args));
    }

    public ElasticsearchException(String msg, Throwable cause, Object ... args) {
        super(LoggerMessageFormat.format(msg, args), cause);
    }

    public ElasticsearchException(StreamInput in) throws IOException {
        super(in.readOptionalString(), (Throwable)in.readException());
        ElasticsearchException.readStackTrace(this, in);
        this.headers.putAll(in.readMapOfLists(StreamInput::readString, StreamInput::readString));
        this.metadata.putAll(in.readMapOfLists(StreamInput::readString, StreamInput::readString));
    }

    public void addMetadata(String key, String ... values) {
        this.addMetadata(key, Arrays.asList(values));
    }

    public void addMetadata(String key, List<String> values) {
        if (!key.startsWith("es.")) {
            throw new IllegalArgumentException("exception metadata must start with [es.], found [" + key + "] instead");
        }
        this.metadata.put(key, values);
    }

    public PGErrorStatus pgErrorStatus() {
        return PGErrorStatus.INTERNAL_ERROR;
    }

    public HttpErrorStatus httpErrorStatus() {
        return HttpErrorStatus.UNHANDLED_SERVER_ERROR;
    }

    public Set<String> getMetadataKeys() {
        return this.metadata.keySet();
    }

    public List<String> getMetadata(String key) {
        return this.metadata.get(key);
    }

    protected Map<String, List<String>> getMetadata() {
        return this.metadata;
    }

    public void addHeader(String key, List<String> value) {
        if (key.startsWith("es.")) {
            throw new IllegalArgumentException("exception headers must not start with [es.], found [" + key + "] instead");
        }
        this.headers.put(key, value);
    }

    public Set<String> getHeaderKeys() {
        return this.headers.keySet();
    }

    public List<String> getHeader(String key) {
        return this.headers.get(key);
    }

    protected Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public RestStatus status() {
        Throwable cause = this.unwrapCause();
        if (cause == this) {
            return RestStatus.INTERNAL_SERVER_ERROR;
        }
        return SQLExceptions.status(cause);
    }

    public Throwable unwrapCause() {
        return SQLExceptions.unwrap(this);
    }

    public String getDetailedMessage() {
        if (this.getCause() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.toString()).append("; ");
            if (this.getCause() instanceof ElasticsearchException) {
                sb.append(((ElasticsearchException)this.getCause()).getDetailedMessage());
            } else {
                sb.append(this.getCause());
            }
            return sb.toString();
        }
        return super.toString();
    }

    public Throwable getRootCause() {
        Throwable rootCause = this;
        for (Throwable cause = this.getCause(); cause != null && cause != rootCause; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.getMessage());
        out.writeException(this.getCause());
        ElasticsearchException.writeStackTraces(this, out, StreamOutput::writeException);
        out.writeMapOfLists(this.headers, StreamOutput::writeString, StreamOutput::writeString);
        out.writeMapOfLists(this.metadata, StreamOutput::writeString, StreamOutput::writeString);
    }

    public static ElasticsearchException readException(StreamInput input, int id) throws IOException {
        CheckedFunction<StreamInput, ? extends ElasticsearchException, IOException> elasticsearchException = ID_TO_SUPPLIER.get(id);
        if (elasticsearchException == null) {
            throw new IllegalStateException("unknown exception for id: " + id);
        }
        return (ElasticsearchException)elasticsearchException.apply((Object)input);
    }

    public static boolean isRegistered(Class<? extends Throwable> exception, Version version) {
        ElasticsearchExceptionHandle elasticsearchExceptionHandle = CLASS_TO_ELASTICSEARCH_EXCEPTION_HANDLE.get(exception);
        if (elasticsearchExceptionHandle != null) {
            return version.onOrAfter(elasticsearchExceptionHandle.versionAdded);
        }
        return false;
    }

    public static int getId(Class<? extends ElasticsearchException> exception) {
        return ElasticsearchException.CLASS_TO_ELASTICSEARCH_EXCEPTION_HANDLE.get(exception).id;
    }

    protected String getExceptionName() {
        return ElasticsearchException.getExceptionName(this);
    }

    public static String getExceptionName(Throwable ex) {
        String simpleName = ex.getClass().getSimpleName();
        if (simpleName.startsWith("Elasticsearch")) {
            simpleName = simpleName.substring("Elasticsearch".length());
        }
        return simpleName;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.metadata.containsKey(INDEX_METADATA_KEY)) {
            builder.append(this.getIndex());
            if (this.metadata.containsKey(SHARD_METADATA_KEY)) {
                builder.append('[').append(this.getShardId()).append(']');
            }
            builder.append(' ');
        }
        return builder.append(super.toString().trim()).toString();
    }

    public static <T extends Throwable> T readStackTrace(T throwable, StreamInput in) throws IOException {
        throwable.setStackTrace(in.readArray(i -> {
            String declaringClasss = i.readString();
            String fileName = i.readOptionalString();
            String methodName = i.readString();
            int lineNumber = i.readVInt();
            return new StackTraceElement(declaringClasss, methodName, fileName, lineNumber);
        }, StackTraceElement[]::new));
        int numSuppressed = in.readVInt();
        for (int i2 = 0; i2 < numSuppressed; ++i2) {
            throwable.addSuppressed((Throwable)in.readException());
        }
        return throwable;
    }

    public static <T extends Throwable> T writeStackTraces(T throwable, StreamOutput out, Writeable.Writer<Throwable> exceptionWriter) throws IOException {
        out.writeArray((o, v) -> {
            o.writeString(v.getClassName());
            o.writeOptionalString(v.getFileName());
            o.writeString(v.getMethodName());
            o.writeVInt(v.getLineNumber());
        }, throwable.getStackTrace());
        out.writeArray(exceptionWriter, throwable.getSuppressed());
        return throwable;
    }

    public Index getIndex() {
        List<String> index = this.getMetadata(INDEX_METADATA_KEY);
        if (index != null && !index.isEmpty()) {
            List<String> index_uuid = this.getMetadata(INDEX_METADATA_KEY_UUID);
            return new Index(index.get(0), index_uuid.get(0));
        }
        return null;
    }

    public ShardId getShardId() {
        List<String> shard = this.getMetadata(SHARD_METADATA_KEY);
        if (shard != null && !shard.isEmpty()) {
            return new ShardId(this.getIndex(), Integer.parseInt(shard.get(0)));
        }
        return null;
    }

    public void setIndex(Index index) {
        if (index != null) {
            this.addMetadata(INDEX_METADATA_KEY, index.getName());
            this.addMetadata(INDEX_METADATA_KEY_UUID, index.getUUID());
        }
    }

    public void setIndex(String index) {
        if (index != null) {
            this.setIndex(new Index(index, "_na_"));
        }
    }

    public void setShard(ShardId shardId) {
        if (shardId != null) {
            this.setIndex(shardId.getIndex());
            this.addMetadata(SHARD_METADATA_KEY, Integer.toString(shardId.id()));
        }
    }

    public void setResources(String type, String ... id) {
        assert (type != null);
        this.addMetadata(RESOURCE_METADATA_ID_KEY, id);
        this.addMetadata(RESOURCE_METADATA_TYPE_KEY, type);
    }

    private static enum ElasticsearchExceptionHandle {
        INDEX_SHARD_SNAPSHOT_FAILED_EXCEPTION(IndexShardSnapshotFailedException.class, IndexShardSnapshotFailedException::new, 0, UNKNOWN_VERSION_ADDED),
        EXECUTION_CANCELLED_EXCEPTION(CancellableThreads.ExecutionCancelledException.class, CancellableThreads.ExecutionCancelledException::new, 2, UNKNOWN_VERSION_ADDED),
        MASTER_NOT_DISCOVERED_EXCEPTION(MasterNotDiscoveredException.class, MasterNotDiscoveredException::new, 3, UNKNOWN_VERSION_ADDED),
        ELASTICSEARCH_SECURITY_EXCEPTION(ElasticsearchSecurityException.class, ElasticsearchSecurityException::new, 4, UNKNOWN_VERSION_ADDED),
        INDEX_SHARD_RESTORE_EXCEPTION(IndexShardRestoreException.class, IndexShardRestoreException::new, 5, UNKNOWN_VERSION_ADDED),
        INDEX_CLOSED_EXCEPTION(IndexClosedException.class, IndexClosedException::new, 6, UNKNOWN_VERSION_ADDED),
        BIND_HTTP_EXCEPTION(BindHttpException.class, BindHttpException::new, 7, UNKNOWN_VERSION_ADDED),
        NODE_CLOSED_EXCEPTION(NodeClosedException.class, NodeClosedException::new, 9, UNKNOWN_VERSION_ADDED),
        SNAPSHOT_FAILED_ENGINE_EXCEPTION(SnapshotFailedEngineException.class, SnapshotFailedEngineException::new, 10, UNKNOWN_VERSION_ADDED),
        SHARD_NOT_FOUND_EXCEPTION(ShardNotFoundException.class, ShardNotFoundException::new, 11, UNKNOWN_VERSION_ADDED),
        CONNECT_TRANSPORT_EXCEPTION(ConnectTransportException.class, ConnectTransportException::new, 12, UNKNOWN_VERSION_ADDED),
        NOT_SERIALIZABLE_TRANSPORT_EXCEPTION(NotSerializableTransportException.class, NotSerializableTransportException::new, 13, UNKNOWN_VERSION_ADDED),
        RESPONSE_HANDLER_FAILURE_TRANSPORT_EXCEPTION(ResponseHandlerFailureTransportException.class, ResponseHandlerFailureTransportException::new, 14, UNKNOWN_VERSION_ADDED),
        INDEX_CREATION_EXCEPTION(IndexCreationException.class, IndexCreationException::new, 15, UNKNOWN_VERSION_ADDED),
        INDEX_NOT_FOUND_EXCEPTION(IndexNotFoundException.class, IndexNotFoundException::new, 16, UNKNOWN_VERSION_ADDED),
        ILLEGAL_SHARD_ROUTING_STATE_EXCEPTION(IllegalShardRoutingStateException.class, IllegalShardRoutingStateException::new, 17, UNKNOWN_VERSION_ADDED),
        BROADCAST_SHARD_OPERATION_FAILED_EXCEPTION(BroadcastShardOperationFailedException.class, BroadcastShardOperationFailedException::new, 18, UNKNOWN_VERSION_ADDED),
        RESOURCE_NOT_FOUND_EXCEPTION(ResourceNotFoundException.class, ResourceNotFoundException::new, 19, UNKNOWN_VERSION_ADDED),
        ACTION_TRANSPORT_EXCEPTION(ActionTransportException.class, ActionTransportException::new, 20, UNKNOWN_VERSION_ADDED),
        ELASTICSEARCH_GENERATION_EXCEPTION(ElasticsearchGenerationException.class, ElasticsearchGenerationException::new, 21, UNKNOWN_VERSION_ADDED),
        INDEX_SHARD_STARTED_EXCEPTION(IndexShardStartedException.class, IndexShardStartedException::new, 23, UNKNOWN_VERSION_ADDED),
        DOCUMENT_MISSING_EXCEPTION(DocumentMissingException.class, DocumentMissingException::new, 29, UNKNOWN_VERSION_ADDED),
        SNAPSHOT_EXCEPTION(SnapshotException.class, SnapshotException::new, 30, UNKNOWN_VERSION_ADDED),
        INVALID_ALIAS_NAME_EXCEPTION(InvalidAliasNameException.class, InvalidAliasNameException::new, 31, UNKNOWN_VERSION_ADDED),
        INVALID_INDEX_NAME_EXCEPTION(InvalidIndexNameException.class, InvalidIndexNameException::new, 32, UNKNOWN_VERSION_ADDED),
        INDEX_PRIMARY_SHARD_NOT_ALLOCATED_EXCEPTION(IndexPrimaryShardNotAllocatedException.class, IndexPrimaryShardNotAllocatedException::new, 33, UNKNOWN_VERSION_ADDED),
        TRANSPORT_EXCEPTION(TransportException.class, TransportException::new, 34, UNKNOWN_VERSION_ADDED),
        ELASTICSEARCH_PARSE_EXCEPTION(ElasticsearchParseException.class, ElasticsearchParseException::new, 35, UNKNOWN_VERSION_ADDED),
        MAPPER_EXCEPTION(MapperException.class, MapperException::new, 37, UNKNOWN_VERSION_ADDED),
        INVALID_TYPE_NAME_EXCEPTION(InvalidTypeNameException.class, InvalidTypeNameException::new, 38, UNKNOWN_VERSION_ADDED),
        SNAPSHOT_RESTORE_EXCEPTION(SnapshotRestoreException.class, SnapshotRestoreException::new, 39, UNKNOWN_VERSION_ADDED),
        PARSING_EXCEPTION(ParsingException.class, ParsingException::new, 40, UNKNOWN_VERSION_ADDED),
        INDEX_SHARD_CLOSED_EXCEPTION(IndexShardClosedException.class, IndexShardClosedException::new, 41, UNKNOWN_VERSION_ADDED),
        RECOVER_FILES_RECOVERY_EXCEPTION(RecoverFilesRecoveryException.class, RecoverFilesRecoveryException::new, 42, UNKNOWN_VERSION_ADDED),
        TRUNCATED_TRANSLOG_EXCEPTION(TruncatedTranslogException.class, TruncatedTranslogException::new, 43, UNKNOWN_VERSION_ADDED),
        RECOVERY_FAILED_EXCEPTION(RecoveryFailedException.class, RecoveryFailedException::new, 44, UNKNOWN_VERSION_ADDED),
        INDEX_SHARD_RELOCATED_EXCEPTION(IndexShardRelocatedException.class, IndexShardRelocatedException::new, 45, UNKNOWN_VERSION_ADDED),
        NODE_SHOULD_NOT_CONNECT_EXCEPTION(NodeShouldNotConnectException.class, NodeShouldNotConnectException::new, 46, UNKNOWN_VERSION_ADDED),
        TRANSLOG_CORRUPTED_EXCEPTION(TranslogCorruptedException.class, TranslogCorruptedException::new, 48, UNKNOWN_VERSION_ADDED),
        CLUSTER_BLOCK_EXCEPTION(ClusterBlockException.class, ClusterBlockException::new, 49, UNKNOWN_VERSION_ADDED),
        VERSION_CONFLICT_ENGINE_EXCEPTION(VersionConflictEngineException.class, VersionConflictEngineException::new, 52, UNKNOWN_VERSION_ADDED),
        ENGINE_EXCEPTION(EngineException.class, EngineException::new, 53, UNKNOWN_VERSION_ADDED),
        NO_SUCH_NODE_EXCEPTION(NoSuchNodeException.class, NoSuchNodeException::new, 55, UNKNOWN_VERSION_ADDED),
        SETTINGS_EXCEPTION(SettingsException.class, SettingsException::new, 56, UNKNOWN_VERSION_ADDED),
        INDEX_TEMPLATE_MISSING_EXCEPTION(IndexTemplateMissingException.class, IndexTemplateMissingException::new, 57, UNKNOWN_VERSION_ADDED),
        SEND_REQUEST_TRANSPORT_EXCEPTION(SendRequestTransportException.class, SendRequestTransportException::new, 58, UNKNOWN_VERSION_ADDED),
        NOT_SERIALIZABLE_EXCEPTION_WRAPPER(NotSerializableExceptionWrapper.class, NotSerializableExceptionWrapper::new, 62, UNKNOWN_VERSION_ADDED),
        GATEWAY_EXCEPTION(GatewayException.class, GatewayException::new, 65, UNKNOWN_VERSION_ADDED),
        INDEX_SHARD_NOT_RECOVERING_EXCEPTION(IndexShardNotRecoveringException.class, IndexShardNotRecoveringException::new, 66, UNKNOWN_VERSION_ADDED),
        HTTP_EXCEPTION(HttpException.class, HttpException::new, 67, UNKNOWN_VERSION_ADDED),
        ELASTICSEARCH_EXCEPTION(ElasticsearchException.class, ElasticsearchException::new, 68, UNKNOWN_VERSION_ADDED),
        SNAPSHOT_MISSING_EXCEPTION(SnapshotMissingException.class, SnapshotMissingException::new, 69, UNKNOWN_VERSION_ADDED),
        PRIMARY_MISSING_ACTION_EXCEPTION(PrimaryMissingActionException.class, PrimaryMissingActionException::new, 70, UNKNOWN_VERSION_ADDED),
        FAILED_NODE_EXCEPTION(FailedNodeException.class, FailedNodeException::new, 71, UNKNOWN_VERSION_ADDED),
        CONCURRENT_SNAPSHOT_EXECUTION_EXCEPTION(ConcurrentSnapshotExecutionException.class, ConcurrentSnapshotExecutionException::new, 73, UNKNOWN_VERSION_ADDED),
        BLOB_STORE_EXCEPTION(BlobStoreException.class, BlobStoreException::new, 74, UNKNOWN_VERSION_ADDED),
        INCOMPATIBLE_CLUSTER_STATE_VERSION_EXCEPTION(IncompatibleClusterStateVersionException.class, IncompatibleClusterStateVersionException::new, 75, UNKNOWN_VERSION_ADDED),
        RECOVERY_ENGINE_EXCEPTION(RecoveryEngineException.class, RecoveryEngineException::new, 76, UNKNOWN_VERSION_ADDED),
        UNCATEGORIZED_EXECUTION_EXCEPTION(UncategorizedExecutionException.class, UncategorizedExecutionException::new, 77, UNKNOWN_VERSION_ADDED),
        INDEX_SHARD_RESTORE_FAILED_EXCEPTION(IndexShardRestoreFailedException.class, IndexShardRestoreFailedException::new, 81, UNKNOWN_VERSION_ADDED),
        REPOSITORY_EXCEPTION(RepositoryException.class, RepositoryException::new, 82, UNKNOWN_VERSION_ADDED),
        RECEIVE_TIMEOUT_TRANSPORT_EXCEPTION(ReceiveTimeoutTransportException.class, ReceiveTimeoutTransportException::new, 83, UNKNOWN_VERSION_ADDED),
        NODE_DISCONNECTED_EXCEPTION(NodeDisconnectedException.class, NodeDisconnectedException::new, 84, UNKNOWN_VERSION_ADDED),
        INVALID_INDEX_TEMPLATE_EXCEPTION(InvalidIndexTemplateException.class, InvalidIndexTemplateException::new, 88, UNKNOWN_VERSION_ADDED),
        REFRESH_FAILED_ENGINE_EXCEPTION(RefreshFailedEngineException.class, RefreshFailedEngineException::new, 90, UNKNOWN_VERSION_ADDED),
        DELAY_RECOVERY_EXCEPTION(DelayRecoveryException.class, DelayRecoveryException::new, 92, UNKNOWN_VERSION_ADDED),
        NO_NODE_AVAILABLE_EXCEPTION(NoNodeAvailableException.class, NoNodeAvailableException::new, 94, UNKNOWN_VERSION_ADDED),
        INVALID_SNAPSHOT_NAME_EXCEPTION(InvalidSnapshotNameException.class, InvalidSnapshotNameException::new, 96, UNKNOWN_VERSION_ADDED),
        ILLEGAL_INDEX_SHARD_STATE_EXCEPTION(IllegalIndexShardStateException.class, IllegalIndexShardStateException::new, 97, UNKNOWN_VERSION_ADDED),
        INDEX_SHARD_SNAPSHOT_EXCEPTION(IndexShardSnapshotException.class, IndexShardSnapshotException::new, 98, UNKNOWN_VERSION_ADDED),
        INDEX_SHARD_NOT_STARTED_EXCEPTION(IndexShardNotStartedException.class, IndexShardNotStartedException::new, 99, UNKNOWN_VERSION_ADDED),
        ACTION_NOT_FOUND_TRANSPORT_EXCEPTION(ActionNotFoundTransportException.class, ActionNotFoundTransportException::new, 101, UNKNOWN_VERSION_ADDED),
        TRANSPORT_SERIALIZATION_EXCEPTION(TransportSerializationException.class, TransportSerializationException::new, 102, UNKNOWN_VERSION_ADDED),
        REMOTE_TRANSPORT_EXCEPTION(RemoteTransportException.class, RemoteTransportException::new, 103, UNKNOWN_VERSION_ADDED),
        ENGINE_CREATION_FAILURE_EXCEPTION(EngineCreationFailureException.class, EngineCreationFailureException::new, 104, UNKNOWN_VERSION_ADDED),
        ROUTING_EXCEPTION(RoutingException.class, RoutingException::new, 105, UNKNOWN_VERSION_ADDED),
        INDEX_SHARD_RECOVERY_EXCEPTION(IndexShardRecoveryException.class, IndexShardRecoveryException::new, 106, UNKNOWN_VERSION_ADDED),
        REPOSITORY_MISSING_EXCEPTION(RepositoryMissingException.class, RepositoryMissingException::new, 107, UNKNOWN_VERSION_ADDED),
        DOCUMENT_SOURCE_MISSING_EXCEPTION(DocumentSourceMissingException.class, DocumentSourceMissingException::new, 109, UNKNOWN_VERSION_ADDED),
        NO_CLASS_SETTINGS_EXCEPTION(NoClassSettingsException.class, NoClassSettingsException::new, 111, UNKNOWN_VERSION_ADDED),
        BIND_TRANSPORT_EXCEPTION(BindTransportException.class, BindTransportException::new, 112, UNKNOWN_VERSION_ADDED),
        ALIASES_NOT_FOUND_EXCEPTION(AliasesNotFoundException.class, AliasesNotFoundException::new, 113, UNKNOWN_VERSION_ADDED),
        INDEX_SHARD_RECOVERING_EXCEPTION(IndexShardRecoveringException.class, IndexShardRecoveringException::new, 114, UNKNOWN_VERSION_ADDED),
        TRANSLOG_EXCEPTION(TranslogException.class, TranslogException::new, 115, UNKNOWN_VERSION_ADDED),
        PROCESS_CLUSTER_EVENT_TIMEOUT_EXCEPTION(ProcessClusterEventTimeoutException.class, ProcessClusterEventTimeoutException::new, 116, UNKNOWN_VERSION_ADDED),
        RETRY_ON_PRIMARY_EXCEPTION(ReplicationOperation.RetryOnPrimaryException.class, ReplicationOperation.RetryOnPrimaryException::new, 117, UNKNOWN_VERSION_ADDED),
        ELASTICSEARCH_TIMEOUT_EXCEPTION(ElasticsearchTimeoutException.class, ElasticsearchTimeoutException::new, 118, UNKNOWN_VERSION_ADDED),
        REPOSITORY_VERIFICATION_EXCEPTION(RepositoryVerificationException.class, RepositoryVerificationException::new, 120, UNKNOWN_VERSION_ADDED),
        RESOURCE_ALREADY_EXISTS_EXCEPTION(ResourceAlreadyExistsException.class, ResourceAlreadyExistsException::new, 123, UNKNOWN_VERSION_ADDED),
        HTTP_REQUEST_ON_TRANSPORT_EXCEPTION(TcpTransport.HttpRequestOnTransportException.class, TcpTransport.HttpRequestOnTransportException::new, 125, UNKNOWN_VERSION_ADDED),
        MAPPER_PARSING_EXCEPTION(MapperParsingException.class, MapperParsingException::new, 126, UNKNOWN_VERSION_ADDED),
        NO_SHARD_AVAILABLE_ACTION_EXCEPTION(NoShardAvailableActionException.class, NoShardAvailableActionException::new, 130, UNKNOWN_VERSION_ADDED),
        UNAVAILABLE_SHARDS_EXCEPTION(UnavailableShardsException.class, UnavailableShardsException::new, 131, UNKNOWN_VERSION_ADDED),
        FLUSH_FAILED_ENGINE_EXCEPTION(FlushFailedEngineException.class, FlushFailedEngineException::new, 132, UNKNOWN_VERSION_ADDED),
        CIRCUIT_BREAKING_EXCEPTION(CircuitBreakingException.class, CircuitBreakingException::new, 133, UNKNOWN_VERSION_ADDED),
        NODE_NOT_CONNECTED_EXCEPTION(NodeNotConnectedException.class, NodeNotConnectedException::new, 134, UNKNOWN_VERSION_ADDED),
        STRICT_DYNAMIC_MAPPING_EXCEPTION(StrictDynamicMappingException.class, StrictDynamicMappingException::new, 135, UNKNOWN_VERSION_ADDED),
        RETRY_ON_REPLICA_EXCEPTION(TransportReplicationAction.RetryOnReplicaException.class, TransportReplicationAction.RetryOnReplicaException::new, 136, UNKNOWN_VERSION_ADDED),
        TYPE_MISSING_EXCEPTION(TypeMissingException.class, TypeMissingException::new, 137, UNKNOWN_VERSION_ADDED),
        FAILED_TO_COMMIT_CLUSTER_STATE_EXCEPTION(FailedToCommitClusterStateException.class, FailedToCommitClusterStateException::new, 140, UNKNOWN_VERSION_ADDED),
        NO_LONGER_PRIMARY_SHARD_EXCEPTION(ShardStateAction.NoLongerPrimaryShardException.class, ShardStateAction.NoLongerPrimaryShardException::new, 142, UNKNOWN_VERSION_ADDED),
        NOT_MASTER_EXCEPTION(NotMasterException.class, NotMasterException::new, 144, UNKNOWN_VERSION_ADDED),
        STATUS_EXCEPTION(ElasticsearchStatusException.class, ElasticsearchStatusException::new, 145, UNKNOWN_VERSION_ADDED),
        TASK_CANCELLED_EXCEPTION(TaskCancelledException.class, TaskCancelledException::new, 146, UNKNOWN_VERSION_ADDED),
        SHARD_LOCK_OBTAIN_FAILED_EXCEPTION(ShardLockObtainFailedException.class, ShardLockObtainFailedException::new, 147, UNKNOWN_VERSION_ADDED),
        COORDINATION_STATE_REJECTED_EXCEPTION(CoordinationStateRejectedException.class, CoordinationStateRejectedException::new, 150, Version.V_4_0_0),
        RETENTION_LEASE_ALREADY_EXISTS_EXCEPTION(RetentionLeaseAlreadyExistsException.class, RetentionLeaseAlreadyExistsException::new, 153, Version.V_4_3_0),
        RETENTION_LEASE_NOT_FOUND_EXCEPTION(RetentionLeaseNotFoundException.class, RetentionLeaseNotFoundException::new, 154, Version.V_4_3_0),
        SHARD_NOT_IN_PRIMARY_MODE_EXCEPTION(ShardNotInPrimaryModeException.class, ShardNotInPrimaryModeException::new, 155, Version.V_4_3_0),
        JOB_KILLED_EXCEPTION(JobKilledException.class, JobKilledException::new, 156, Version.V_4_3_0),
        TASK_MISSING_EXCEPTION(TaskMissing.class, TaskMissing::new, 157, Version.V_4_3_0),
        RETENTION_LEASE_INVALID_RETAINING_SEQUENCE_NUMBER_EXCEPTION(RetentionLeaseInvalidRetainingSeqNoException.class, RetentionLeaseInvalidRetainingSeqNoException::new, 158, Version.V_4_3_0),
        RELATION_ALREADY_EXISTS(RelationAlreadyExists.class, RelationAlreadyExists::new, 159, Version.V_4_7_0),
        RELATION_UNKNOWN(RelationUnknown.class, RelationUnknown::new, 160, Version.V_4_7_0),
        SCHEMA_UNKNOWN(SchemaUnknownException.class, SchemaUnknownException::new, 161, Version.V_4_7_0),
        GROUP_BY_ON_ARRAY_UNSUPPORTED_EXCEPTION(ArrayViaDocValuesUnsupportedException.class, ArrayViaDocValuesUnsupportedException::new, 162, Version.V_4_7_0),
        INVALID_ARGUMENT_EXCEPTION(InvalidArgumentException.class, InvalidArgumentException::new, 163, Version.V_4_7_0),
        INVALID_COLUMN_NAME_EXCEPTION(InvalidColumnNameException.class, InvalidColumnNameException::new, 164, Version.V_4_7_0),
        UNSUPPORTED_FEATURE_EXCEPTION(UnsupportedFeatureException.class, UnsupportedFeatureException::new, 165, Version.V_4_7_0),
        USER_DEFINED_FUNCTION_ALREADY_EXISTS_EXCEPTION(UserDefinedFunctionAlreadyExistsException.class, UserDefinedFunctionAlreadyExistsException::new, 166, Version.V_4_7_0),
        USER_DEFINED_FUNCTION_UNKNOWN_EXCEPTION(UserDefinedFunctionUnknownException.class, UserDefinedFunctionUnknownException::new, 167, Version.V_4_7_0),
        VERSIONING_VALIDATION_EXCEPTION(VersioningValidationException.class, VersioningValidationException::new, 168, Version.V_4_7_0),
        PUBLICATION_ALREADY_EXISTS_EXCEPTION(PublicationAlreadyExistsException.class, PublicationAlreadyExistsException::new, 169, Version.V_4_7_0),
        PUBLICATION_UNKNOWN_EXCEPTION(PublicationUnknownException.class, PublicationUnknownException::new, 170, Version.V_4_7_0),
        SUBSCRIPTION_ALREADY_EXISTS_EXCEPTION(SubscriptionAlreadyExistsException.class, SubscriptionAlreadyExistsException::new, 171, Version.V_4_7_0),
        SUBSCRIPTION_UNKNOWN_EXCEPTION(SubscriptionUnknownException.class, SubscriptionUnknownException::new, 172, Version.V_4_7_0),
        MISSING_SHARD_OPERATIONS_EXCEPTION(MissingShardOperationsException.class, MissingShardOperationsException::new, 173, Version.V_4_7_0),
        PEER_RECOVERY_NOT_FOUND_EXCEPTION(PeerRecoveryNotFound.class, PeerRecoveryNotFound::new, 174, Version.V_5_1_0),
        NODE_HEALTH_CHECK_FAILURE_EXCEPTION(NodeHealthCheckFailureException.class, NodeHealthCheckFailureException::new, 175, Version.V_5_2_0),
        OPERATION_ON_INACCESSIBLE_RELATION_EXCEPTION(OperationOnInaccessibleRelationException.class, OperationOnInaccessibleRelationException::new, 176, Version.V_5_6_0),
        UNAUTHORIZED_EXCEPTION(UnauthorizedException.class, UnauthorizedException::new, 177, Version.V_5_7_0),
        SERVER_ALREADY_EXISTS(ServerAlreadyExistsException.class, ServerAlreadyExistsException::new, 178, Version.V_5_7_0),
        USER_MAPPING_ALREADY_EXISTS(UserMappingAlreadyExists.class, UserMappingAlreadyExists::new, 179, Version.V_5_7_0),
        ROLE_ALREADY_EXISTS(RoleAlreadyExistsException.class, RoleAlreadyExistsException::new, 180, Version.V_5_7_0),
        ROLE_UNKNOWN(RoleUnknownException.class, RoleUnknownException::new, 181, Version.V_5_7_0);

        final Class<? extends ElasticsearchException> exceptionClass;
        final CheckedFunction<StreamInput, ? extends ElasticsearchException, IOException> constructor;
        final int id;
        final Version versionAdded;

        private <E extends ElasticsearchException> ElasticsearchExceptionHandle(Class<E> exceptionClass, CheckedFunction<StreamInput, E, IOException> constructor, int id, Version versionAdded) {
            this.exceptionClass = exceptionClass;
            this.constructor = constructor;
            this.versionAdded = versionAdded;
            this.id = id;
        }
    }
}

