/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;

public class ActionListenerResponseHandler<Response extends TransportResponse>
implements TransportResponseHandler<Response> {
    private final ActionListener<? super Response> listener;
    private final Writeable.Reader<Response> reader;
    private final String executor;

    public ActionListenerResponseHandler(ActionListener<? super Response> listener, Writeable.Reader<Response> reader, String executor) {
        this.listener = Objects.requireNonNull(listener);
        this.reader = Objects.requireNonNull(reader);
        this.executor = Objects.requireNonNull(executor);
    }

    public ActionListenerResponseHandler(ActionListener<? super Response> listener, Writeable.Reader<Response> reader) {
        this(listener, reader, "same");
    }

    @Override
    public void handleResponse(Response response) {
        this.listener.onResponse(response);
    }

    @Override
    public void handleException(TransportException e) {
        this.listener.onFailure(e);
    }

    @Override
    public Response read(StreamInput in) throws IOException {
        return (Response)((TransportResponse)this.reader.read(in));
    }

    @Override
    public String executor() {
        return this.executor;
    }
}

