/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.delete;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.Index;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteIndexAction
extends TransportMasterNodeAction<DeleteIndexRequest, AcknowledgedResponse> {
    private final MetadataDeleteIndexService deleteIndexService;

    @Inject
    public TransportDeleteIndexAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataDeleteIndexService deleteIndexService) {
        super("indices:admin/delete", transportService, clusterService, threadPool, DeleteIndexRequest::new);
        this.deleteIndexService = deleteIndexService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteIndexRequest request, ClusterState state) {
        return state.blocks().indicesAllowReleaseResources(IndexNameExpressionResolver.concreteIndexNames(state, request));
    }

    @Override
    protected void masterOperation(final DeleteIndexRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        Index[] concreteIndices = IndexNameExpressionResolver.concreteIndices(state, request);
        if (concreteIndices.length == 0) {
            listener.onResponse(new AcknowledgedResponse(true));
            return;
        }
        String source = "delete-index " + Arrays.toString(request.indices());
        AckedClusterStateUpdateTask<AcknowledgedResponse> updateTask = new AckedClusterStateUpdateTask<AcknowledgedResponse>(this, Priority.URGENT, (AckedRequest)request, listener){
            final /* synthetic */ TransportDeleteIndexAction this$0;
            {
                this.this$0 = this$0;
                super(priority, request2, listener);
            }

            @Override
            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                Index[] concreteIndices = IndexNameExpressionResolver.concreteIndices(currentState, request);
                return this.this$0.deleteIndexService.deleteIndices(currentState, Arrays.asList(concreteIndices));
            }
        };
        this.clusterService.submitStateUpdateTask(source, updateTask);
    }
}

