/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.settings.put;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;

public class UpdateSettingsRequest
extends AcknowledgedRequest<UpdateSettingsRequest>
implements IndicesRequest {
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, false, true, true);
    private Settings settings = Settings.EMPTY;

    public UpdateSettingsRequest(Settings settings, String ... indices) {
        this.indices = indices;
        this.settings = settings;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    public Settings settings() {
        return this.settings;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public UpdateSettingsRequest settings(String source, XContentType xContentType) {
        this.settings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public UpdateSettingsRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.settings = Settings.readSettingsFromStream(in);
        if (in.getVersion().before(Version.V_5_10_0)) {
            in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        Settings.writeSettingsToStream(out, this.settings);
        if (out.getVersion().before(Version.V_5_10_0)) {
            out.writeBoolean(false);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateSettingsRequest that = (UpdateSettingsRequest)o;
        return this.masterNodeTimeout.equals((Object)that.masterNodeTimeout) && this.timeout.equals((Object)that.timeout) && Objects.equals(this.settings, that.settings) && Objects.equals(this.indicesOptions, that.indicesOptions) && Arrays.equals(this.indices, that.indices);
    }

    public int hashCode() {
        return Objects.hash(this.masterNodeTimeout, this.timeout, this.settings, this.indicesOptions, Arrays.hashCode(this.indices));
    }
}

