/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.elasticsearch.action.admin.indices.stats.ShardStats;

public class IndexStats
implements Iterable<IndexShardStats> {
    private final List<ShardStats> shards;
    private Map<Integer, IndexShardStats> indexShards;

    public IndexStats(List<ShardStats> shards) {
        this.shards = shards;
    }

    public List<ShardStats> getShards() {
        return this.shards;
    }

    public Map<Integer, IndexShardStats> getIndexShards() {
        if (this.indexShards != null) {
            return this.indexShards;
        }
        HashMap<Integer, ArrayList<ShardStats>> tmpIndexShards = new HashMap<Integer, ArrayList<ShardStats>>();
        for (ShardStats shardStats : this.shards) {
            ArrayList<ShardStats> lst = (ArrayList<ShardStats>)tmpIndexShards.get(shardStats.getShardRouting().id());
            if (lst == null) {
                lst = new ArrayList<ShardStats>();
                tmpIndexShards.put(shardStats.getShardRouting().id(), lst);
            }
            lst.add(shardStats);
        }
        this.indexShards = HashMap.newHashMap(tmpIndexShards.size());
        for (Map.Entry entry : tmpIndexShards.entrySet()) {
            List shardStats = (List)entry.getValue();
            this.indexShards.put((Integer)entry.getKey(), new IndexShardStats(shardStats));
        }
        return this.indexShards;
    }

    @Override
    public Iterator<IndexShardStats> iterator() {
        return this.getIndexShards().values().iterator();
    }
}

