/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Predicate;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class ClusterName
implements Writeable {
    public static final Setting<ClusterName> CLUSTER_NAME_SETTING = new Setting<ClusterName>("cluster.name", "crate", s -> {
        if (s.isEmpty()) {
            throw new IllegalArgumentException("[cluster.name] must not be empty");
        }
        return new ClusterName((String)s);
    }, DataTypes.STRING, Setting.Property.NodeScope);
    public static final ClusterName DEFAULT = CLUSTER_NAME_SETTING.getDefault(Settings.EMPTY);
    private final String value;

    public ClusterName(StreamInput input) throws IOException {
        this(input.readString());
    }

    public ClusterName(String value) {
        this.value = value.intern();
    }

    public String value() {
        return this.value;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterName that = (ClusterName)o;
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "Cluster [" + this.value + "]";
    }

    public Predicate<ClusterName> getEqualityPredicate() {
        return new Predicate<ClusterName>(){

            @Override
            public boolean test(ClusterName o) {
                return ClusterName.this.equals(o);
            }

            public String toString() {
                return "local cluster name [" + ClusterName.this.value() + "]";
            }
        };
    }
}

