/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import io.crate.common.collections.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;

public interface AliasOrIndex {
    public boolean isAlias();

    public List<IndexMetadata> getIndices();

    public static class Alias
    implements AliasOrIndex {
        private final String aliasName;
        private final List<IndexMetadata> referenceIndexMetadatas;

        public Alias(AliasMetadata aliasMetadata, IndexMetadata indexMetadata) {
            this.aliasName = aliasMetadata.getAlias();
            this.referenceIndexMetadatas = new ArrayList<IndexMetadata>();
            this.referenceIndexMetadatas.add(indexMetadata);
        }

        @Override
        public boolean isAlias() {
            return true;
        }

        public String getAliasName() {
            return this.aliasName;
        }

        @Override
        public List<IndexMetadata> getIndices() {
            return this.referenceIndexMetadatas;
        }

        public Iterable<Tuple<String, AliasMetadata>> getConcreteIndexAndAliasMetadatas() {
            return new Iterable<Tuple<String, AliasMetadata>>(){

                @Override
                public Iterator<Tuple<String, AliasMetadata>> iterator() {
                    return new Iterator<Tuple<String, AliasMetadata>>(){
                        int index = 0;

                        @Override
                        public boolean hasNext() {
                            return this.index < referenceIndexMetadatas.size();
                        }

                        @Override
                        public Tuple<String, AliasMetadata> next() {
                            IndexMetadata indexMetadata = referenceIndexMetadatas.get(this.index++);
                            return new Tuple((Object)indexMetadata.getIndex().getName(), (Object)indexMetadata.getAliases().get(aliasName));
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }

        public AliasMetadata getFirstAliasMetadata() {
            return this.referenceIndexMetadatas.get(0).getAliases().get(this.aliasName);
        }

        void addIndex(IndexMetadata indexMetadata) {
            this.referenceIndexMetadatas.add(indexMetadata);
        }
    }

    public static class Index
    implements AliasOrIndex {
        private final IndexMetadata concreteIndex;

        public Index(IndexMetadata indexMetadata) {
            this.concreteIndex = indexMetadata;
        }

        @Override
        public boolean isAlias() {
            return false;
        }

        @Override
        public List<IndexMetadata> getIndices() {
            return Collections.singletonList(this.concreteIndex);
        }

        public IndexMetadata getIndex() {
            return this.concreteIndex;
        }
    }
}

