/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexGraveyard;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.snapshots.SnapshotInProgressException;
import org.elasticsearch.snapshots.SnapshotsService;

public class MetadataDeleteIndexService {
    private static final Logger LOGGER = LogManager.getLogger(MetadataDeleteIndexService.class);
    private final Settings settings;
    private final AllocationService allocationService;

    @Inject
    public MetadataDeleteIndexService(Settings settings, AllocationService allocationService) {
        this.settings = settings;
        this.allocationService = allocationService;
    }

    public ClusterState deleteIndices(ClusterState currentState, Collection<Index> indices) {
        return MetadataDeleteIndexService.deleteIndices(currentState, this.settings, this.allocationService, indices);
    }

    public static ClusterState deleteIndices(ClusterState currentState, Settings settings, AllocationService allocationService, Collection<Index> indices) {
        Metadata meta = currentState.metadata();
        Set<Index> indicesToDelete = indices.stream().map(i -> meta.getIndexSafe((Index)i).getIndex()).collect(Collectors.toSet());
        Set<Index> snapshottingIndices = SnapshotsService.snapshottingIndices(currentState, indicesToDelete);
        if (!snapshottingIndices.isEmpty()) {
            throw new SnapshotInProgressException("Cannot delete indices that are being snapshotted: " + String.valueOf(snapshottingIndices) + ". Try again after snapshot finishes or cancel the currently running snapshot.");
        }
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
        Metadata.Builder metadataBuilder = Metadata.builder(meta);
        ClusterBlocks.Builder clusterBlocksBuilder = ClusterBlocks.builder().blocks(currentState.blocks());
        IndexGraveyard.Builder graveyardBuilder = IndexGraveyard.builder(metadataBuilder.indexGraveyard());
        int previousGraveyardSize = graveyardBuilder.tombstones().size();
        for (Index index : indicesToDelete) {
            String indexName = index.getName();
            LOGGER.info("{} deleting index", (Object)index);
            routingTableBuilder.remove(indexName);
            clusterBlocksBuilder.removeIndexBlocks(indexName);
            metadataBuilder.remove(indexName);
        }
        IndexGraveyard currentGraveyard = graveyardBuilder.addTombstones(indicesToDelete).build(settings);
        metadataBuilder.indexGraveyard(currentGraveyard);
        LOGGER.trace("{} tombstones purged from the cluster state. Previous tombstone size: {}. Current tombstone size: {}.", (Object)graveyardBuilder.getNumPurged(), (Object)previousGraveyardSize, (Object)currentGraveyard.getTombstones().size());
        Metadata newMetadata = metadataBuilder.build();
        ClusterBlocks blocks = clusterBlocksBuilder.build();
        ImmutableOpenMap<String, ClusterState.Custom> customs = currentState.customs();
        RestoreInProgress restoreInProgress = currentState.custom("restore", RestoreInProgress.EMPTY);
        RestoreInProgress updatedRestoreInProgress = RestoreService.updateRestoreStateWithDeletedIndices(restoreInProgress, indicesToDelete);
        if (updatedRestoreInProgress != restoreInProgress) {
            ImmutableOpenMap.Builder<String, ClusterState.Custom> builder = ImmutableOpenMap.builder(customs);
            builder.put("restore", updatedRestoreInProgress);
            customs = builder.build();
        }
        return allocationService.reroute(ClusterState.builder(currentState).routingTable(routingTableBuilder.build()).metadata(newMetadata).blocks(blocks).customs(customs).build(), "deleted indices [" + String.valueOf(indicesToDelete) + "]");
    }
}

