/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import io.crate.expression.udf.UserDefinedFunctionService;
import io.crate.expression.udf.UserDefinedFunctionsMetadata;
import io.crate.metadata.NodeContext;
import io.crate.metadata.doc.DocTableInfoFactory;
import java.util.Collection;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class MetadataIndexUpgradeService {
    private static final Logger LOGGER = LogManager.getLogger(MetadataIndexUpgradeService.class);
    private final IndexScopedSettings indexScopedSettings;
    private final BiFunction<IndexMetadata, IndexTemplateMetadata, IndexMetadata> upgraders;
    private final DocTableInfoFactory tableFactory;
    private final UserDefinedFunctionService userDefinedFunctionService;

    public MetadataIndexUpgradeService(NodeContext nodeContext, IndexScopedSettings indexScopedSettings, Collection<BiFunction<IndexMetadata, IndexTemplateMetadata, IndexMetadata>> indexMetadataUpgraders, UserDefinedFunctionService userDefinedFunctionService) {
        this.tableFactory = new DocTableInfoFactory(nodeContext);
        this.indexScopedSettings = indexScopedSettings;
        this.upgraders = (indexMetadata, indexTemplateMetadata) -> {
            IndexMetadata newIndexMetadata = indexMetadata;
            for (BiFunction upgrader : indexMetadataUpgraders) {
                newIndexMetadata = (IndexMetadata)upgrader.apply(newIndexMetadata, indexTemplateMetadata);
            }
            return newIndexMetadata;
        };
        this.userDefinedFunctionService = userDefinedFunctionService;
    }

    public IndexMetadata upgradeIndexMetadata(IndexMetadata indexMetadata, IndexTemplateMetadata indexTemplateMetadata, Version minimumIndexCompatibilityVersion, @Nullable UserDefinedFunctionsMetadata userDefinedFunctionsMetadata) {
        if (this.isUpgraded(indexMetadata)) {
            return indexMetadata;
        }
        if (userDefinedFunctionsMetadata != null) {
            this.userDefinedFunctionService.updateImplementations(userDefinedFunctionsMetadata.functionsMetadata());
        }
        this.checkSupportedVersion(indexMetadata, minimumIndexCompatibilityVersion);
        IndexMetadata newMetadata = indexMetadata;
        newMetadata = this.archiveBrokenIndexSettings(newMetadata);
        newMetadata = this.upgraders.apply(newMetadata, indexTemplateMetadata);
        this.checkMappingsCompatibility(newMetadata);
        return this.markAsUpgraded(newMetadata);
    }

    boolean isUpgraded(IndexMetadata indexMetadata) {
        return indexMetadata.getUpgradedVersion().onOrAfter(Version.CURRENT);
    }

    private void checkSupportedVersion(IndexMetadata indexMetadata, Version minimumIndexCompatibilityVersion) {
        if (indexMetadata.getState() == IndexMetadata.State.OPEN && !MetadataIndexUpgradeService.isSupportedVersion(indexMetadata, minimumIndexCompatibilityVersion)) {
            throw new IllegalStateException("The index [" + String.valueOf(indexMetadata.getIndex()) + "] was created with version [" + String.valueOf(indexMetadata.getCreationVersion()) + "] but the minimum compatible version is [" + String.valueOf(minimumIndexCompatibilityVersion) + "].It should be re-indexed in the previous major version of CrateDB before upgrading to " + String.valueOf(Version.CURRENT) + ".");
        }
    }

    private static boolean isSupportedVersion(IndexMetadata indexMetadata, Version minimumIndexCompatibilityVersion) {
        return indexMetadata.getCreationVersion().onOrAfter(minimumIndexCompatibilityVersion);
    }

    @VisibleForTesting
    void checkMappingsCompatibility(IndexMetadata indexMetadata) {
        try {
            this.tableFactory.validateSchema(indexMetadata);
        }
        catch (Exception ex) {
            throw new IllegalStateException("unable to upgrade the mappings for the index [" + String.valueOf(indexMetadata.getIndex()) + "]", ex);
        }
    }

    private IndexMetadata markAsUpgraded(IndexMetadata indexMetadata) {
        Settings settings = Settings.builder().put(indexMetadata.getSettings()).put("index.version.upgraded", Version.CURRENT).build();
        return IndexMetadata.builder(indexMetadata).settings(settings).build();
    }

    IndexMetadata archiveBrokenIndexSettings(IndexMetadata indexMetadata) {
        Settings settings = indexMetadata.getSettings();
        Settings upgrade = this.indexScopedSettings.archiveUnknownOrInvalidSettings(settings, e -> LOGGER.warn("{} ignoring unknown index setting: [{}] with value [{}]; archiving", (Object)indexMetadata.getIndex(), e.getKey(), e.getValue()), (e, ex) -> LOGGER.warn(() -> new ParameterizedMessage("{} ignoring invalid index setting: [{}] with value [{}]; archiving", new Object[]{indexMetadata.getIndex(), e.getKey(), e.getValue()}), (Throwable)ex));
        if (upgrade != settings) {
            return IndexMetadata.builder(indexMetadata).settings(upgrade).build();
        }
        return indexMetadata;
    }
}

