/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.node.Node;

public abstract class DiscoveryNodeRole {
    private final String roleName;
    private final String roleNameAbbreviation;
    public static final DiscoveryNodeRole DATA_ROLE = new DiscoveryNodeRole("data", "d"){

        @Override
        protected Setting<Boolean> roleSetting() {
            return Node.NODE_DATA_SETTING;
        }
    };
    public static final DiscoveryNodeRole MASTER_ROLE = new DiscoveryNodeRole("master", "m"){

        @Override
        protected Setting<Boolean> roleSetting() {
            return Node.NODE_MASTER_SETTING;
        }
    };
    public static Set<DiscoveryNodeRole> BUILT_IN_ROLES = Set.of(DATA_ROLE, MASTER_ROLE);

    public final String roleName() {
        return this.roleName;
    }

    public final String roleNameAbbreviation() {
        return this.roleNameAbbreviation;
    }

    protected DiscoveryNodeRole(String roleName, String roleNameAbbreviation) {
        this.roleName = Objects.requireNonNull(roleName);
        this.roleNameAbbreviation = Objects.requireNonNull(roleNameAbbreviation);
    }

    protected abstract Setting<Boolean> roleSetting();

    public String toString() {
        return "DiscoveryNodeRole{roleName='" + this.roleName + "', roleNameAbbreviation='" + this.roleNameAbbreviation + "'}";
    }

    static class UnknownRole
    extends DiscoveryNodeRole {
        UnknownRole(String roleName, String roleNameAbbreviation) {
            super(roleName, roleNameAbbreviation);
        }

        @Override
        protected Setting<Boolean> roleSetting() {
            assert (false);
            return Setting.boolSetting("node. " + this.roleName(), false, Setting.Property.NodeScope);
        }
    }
}

