/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import io.crate.common.collections.Lists;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.service.SourcePrioritizedRunnable;
import org.elasticsearch.cluster.service.TaskBatcher;
import org.elasticsearch.common.Priority;

public final class BatchedTask<T>
extends SourcePrioritizedRunnable {
    private final TaskBatcher<T> taskBatcher;
    protected final AtomicBoolean processed = new AtomicBoolean();
    protected final ClusterStateTaskExecutor<T> batchingKey;
    protected final T task;
    protected final ClusterStateTaskListener listener;

    public BatchedTask(TaskBatcher<T> taskBatcher, Priority priority, String source, T task, ClusterStateTaskListener listener, ClusterStateTaskExecutor<T> batchingKey) {
        super(priority, source);
        this.taskBatcher = taskBatcher;
        this.batchingKey = batchingKey;
        this.task = task;
        this.listener = listener;
    }

    @Override
    public void run() {
        this.taskBatcher.runIfNotProcessed(this);
    }

    @Override
    public String toString() {
        String taskDescription = this.describeTasks(Collections.singletonList(this));
        if (taskDescription.isEmpty()) {
            return "[" + this.source + "]";
        }
        return "[" + this.source + "[" + taskDescription + "]]";
    }

    public String describeTasks(List<? extends BatchedTask<T>> tasks) {
        return this.batchingKey.describeTasks(Lists.mapLazy(tasks, BatchedTask::getTask));
    }

    public T getTask() {
        return this.task;
    }
}

