/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.jetbrains.annotations.Nullable;

public class Strings {
    public static final String[] EMPTY_ARRAY = new String[0];
    public static final Set<Character> INVALID_FILENAME_CHARS = Set.of(Character.valueOf('\\'), Character.valueOf('/'), Character.valueOf('*'), Character.valueOf('?'), Character.valueOf('\"'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('|'), Character.valueOf(' '), Character.valueOf(','));

    public static List<String> splitSmart(String s, String separator, boolean decode) {
        ArrayList<String> lst = new ArrayList<String>(2);
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int end = s.length();
        while (pos < end) {
            int ch;
            if (s.startsWith(separator, pos)) {
                if (sb.length() > 0) {
                    lst.add(sb.toString());
                    sb = new StringBuilder();
                }
                pos += separator.length();
                continue;
            }
            if ((ch = s.charAt(pos++)) == 92) {
                if (!decode) {
                    sb.append((char)ch);
                }
                if (pos >= end) break;
                ch = s.charAt(pos++);
                if (decode) {
                    switch (ch) {
                        case 110: {
                            ch = 10;
                            break;
                        }
                        case 116: {
                            ch = 9;
                            break;
                        }
                        case 114: {
                            ch = 13;
                            break;
                        }
                        case 98: {
                            ch = 8;
                            break;
                        }
                        case 102: {
                            ch = 12;
                            break;
                        }
                    }
                }
            }
            sb.append((char)ch);
        }
        if (sb.length() > 0) {
            lst.add(sb.toString());
        }
        return lst;
    }

    public static boolean hasLength(@Nullable CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static String trimLeadingCharacter(String str, char leadingCharacter) {
        if (!Strings.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && sb.charAt(0) == leadingCharacter) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static boolean isNullOrEmpty(@Nullable CharSequence str) {
        return !Strings.hasLength(str);
    }

    public static boolean hasText(CharSequence str) {
        if (!Strings.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        for (int j = 0; j < substring.length(); ++j) {
            int i = index + j;
            if (i < str.length() && str.charAt(i) == substring.charAt(j)) continue;
            return false;
        }
        return true;
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (!Strings.hasLength(inString) || !Strings.hasLength(oldPattern) || newPattern == null) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString, pos, index);
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    public static String capitalize(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length());
        sb.append(Character.toUpperCase(str.charAt(0)));
        sb.append(str.substring(1));
        return sb.toString();
    }

    public static boolean validFileName(String fileName) {
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (!INVALID_FILENAME_CHARS.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    public static boolean validFileNameExcludingAstrix(String fileName) {
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (c == '*' || !INVALID_FILENAME_CHARS.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    public static String[] splitStringByCommaToArray(String s) {
        if (s == null || s.isEmpty()) {
            return EMPTY_ARRAY;
        }
        return s.split(",");
    }

    public static String[] split(String toSplit, String delimiter) {
        if (!Strings.hasLength(toSplit) || !Strings.hasLength(delimiter)) {
            return null;
        }
        int offset = toSplit.indexOf(delimiter);
        if (offset < 0) {
            return null;
        }
        String beforeDelimiter = toSplit.substring(0, offset);
        String afterDelimiter = toSplit.substring(offset + delimiter.length());
        return new String[]{beforeDelimiter, afterDelimiter};
    }

    public static String[] tokenizeToStringArray(String s, String delimiters) {
        if (s == null) {
            return EMPTY_ARRAY;
        }
        StringTokenizer tokenizer = new StringTokenizer(s, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens.toArray(new String[0]);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter) {
        if (str == null) {
            return EMPTY_ARRAY;
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if ("".equals(delimiter)) {
            for (int i = 0; i < str.length(); ++i) {
                result.add(str.substring(i, i + 1));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(str.substring(pos, delPos));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(str.substring(pos));
            }
        }
        return result.toArray(new String[0]);
    }

    public static String[] commaDelimitedListToStringArray(String str) {
        return Strings.delimitedListToStringArray(str, ",");
    }

    public static Set<String> commaDelimitedListToSet(String str) {
        TreeSet<String> set = new TreeSet<String>();
        String[] tokens = Strings.commaDelimitedListToStringArray(str);
        set.addAll(Arrays.asList(tokens));
        return set;
    }

    public static String arrayToCommaDelimitedString(Object[] arr) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static String format1Decimals(double value, String suffix) {
        String p = String.valueOf(value);
        int ix = p.indexOf(46) + 1;
        int ex = p.indexOf(69);
        char fraction = p.charAt(ix);
        if (fraction == '0') {
            if (ex != -1) {
                return p.substring(0, ix - 1) + p.substring(ex) + suffix;
            }
            return p.substring(0, ix - 1) + suffix;
        }
        if (ex != -1) {
            return p.substring(0, ix) + fraction + p.substring(ex) + suffix;
        }
        return p.substring(0, ix) + fraction + suffix;
    }

    private Strings() {
    }

    public static String toString(XContentBuilder xContentBuilder) {
        return BytesReference.bytes(xContentBuilder).utf8ToString();
    }

    public static String padStart(String s, int minimumLength, char c) {
        if (s == null) {
            throw new NullPointerException("s");
        }
        if (s.length() >= minimumLength) {
            return s;
        }
        StringBuilder sb = new StringBuilder(minimumLength);
        for (int i = s.length(); i < minimumLength; ++i) {
            sb.append(c);
        }
        sb.append(s);
        return sb.toString();
    }
}

