/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.util.Locale;
import org.apache.lucene.document.ShapeField;

public enum ShapeRelation {
    INTERSECTS("intersects"),
    DISJOINT("disjoint"),
    WITHIN("within"),
    CONTAINS("contains");

    private final String relationName;

    private ShapeRelation(String relationName) {
        this.relationName = relationName;
    }

    public static ShapeRelation getRelationByName(String name) {
        name = name.toLowerCase(Locale.ENGLISH);
        for (ShapeRelation relation : ShapeRelation.values()) {
            if (!relation.relationName.equals(name)) continue;
            return relation;
        }
        return null;
    }

    public ShapeField.QueryRelation getLuceneRelation() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ShapeField.QueryRelation.INTERSECTS;
            case 1 -> ShapeField.QueryRelation.DISJOINT;
            case 2 -> ShapeField.QueryRelation.WITHIN;
            case 3 -> ShapeField.QueryRelation.CONTAINS;
        };
    }

    public String getRelationName() {
        return this.relationName;
    }
}

