/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.geo.GeoShapeType;
import org.elasticsearch.common.geo.XShapeCollection;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;

public class MultiPointBuilder
extends ShapeBuilder<XShapeCollection<Point>, MultiPointBuilder> {
    public static final GeoShapeType TYPE = GeoShapeType.MULTIPOINT;

    public MultiPointBuilder(List<Coordinate> coordinates) {
        super(coordinates);
    }

    @Override
    public XShapeCollection<Point> buildS4J() {
        ArrayList<Point> shapes = new ArrayList<Point>(this.coordinates.size());
        for (Coordinate coord : this.coordinates) {
            shapes.add(SHAPE_FACTORY.pointXY(coord.x, coord.y));
        }
        XShapeCollection<Point> multiPoints = new XShapeCollection<Point>(shapes, (SpatialContext)SPATIAL_CONTEXT);
        multiPoints.setPointsOnly(true);
        return multiPoints;
    }

    public org.apache.lucene.geo.Point[] buildLucene() {
        org.apache.lucene.geo.Point[] points = new org.apache.lucene.geo.Point[this.coordinates.size()];
        for (int i = 0; i < this.coordinates.size(); ++i) {
            Coordinate coord = (Coordinate)this.coordinates.get(i);
            points[i] = new org.apache.lucene.geo.Point(coord.y, coord.x);
        }
        return points;
    }
}

