/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import io.crate.common.collections.Lists;
import io.crate.common.collections.RingBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.SuppressLoggerChecks;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.jetbrains.annotations.VisibleForTesting;

public class DeprecationLogger {
    private static final ThreadLocal<RingBuffer<String>> RECENT_WARNINGS = ThreadLocal.withInitial(() -> new RingBuffer(20));
    private final Logger logger;
    private final Set<String> keys = Collections.newSetFromMap(Collections.synchronizedMap(new LinkedHashMap<String, Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
            return this.size() > 128;
        }
    }));

    public DeprecationLogger(Logger parentLogger) {
        Object name = parentLogger.getName();
        name = ((String)name).startsWith("org.elasticsearch") ? ((String)name).replace("org.elasticsearch.", "org.elasticsearch.deprecation.") : "deprecation." + (String)name;
        this.logger = LogManager.getLogger((String)name);
    }

    @VisibleForTesting
    public void resetLRU() {
        this.keys.clear();
    }

    public void deprecatedAndMaybeLog(String key, String msg, Object ... params) {
        this.deprecated(msg, this.keys.add(key), params);
    }

    @SuppressLoggerChecks(reason="safely delegates to logger")
    void deprecated(String message, boolean shouldLog, Object ... params) {
        if (shouldLog) {
            this.logger.warn(message, params);
            String msg = LoggerMessageFormat.format(message, params);
            RECENT_WARNINGS.get().add((Object)msg);
        }
    }

    public static List<String> getRecentWarnings() {
        return Lists.of((Iterable)((Iterable)RECENT_WARNINGS.get()));
    }

    public static void resetWarnings() {
        RECENT_WARNINGS.get().reset();
    }
}

