/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import io.crate.metadata.IndexName;
import io.crate.metadata.PartitionName;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexUpgradeService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class LocalAllocateDangledIndices {
    private static final Logger LOGGER = LogManager.getLogger(LocalAllocateDangledIndices.class);
    public static final String ACTION_NAME = "internal:gateway/local/allocate_dangled";
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final MetadataIndexUpgradeService metadataIndexUpgradeService;

    @Inject
    public LocalAllocateDangledIndices(TransportService transportService, ClusterService clusterService, AllocationService allocationService, MetadataIndexUpgradeService metadataIndexUpgradeService) {
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.allocationService = allocationService;
        this.metadataIndexUpgradeService = metadataIndexUpgradeService;
        transportService.registerRequestHandler(ACTION_NAME, "same", AllocateDangledRequest::new, new AllocateDangledRequestHandler());
    }

    public void allocateDangled(Collection<IndexMetadata> indices, ActionListener<AllocateDangledResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        DiscoveryNode masterNode = clusterState.nodes().getMasterNode();
        if (masterNode == null) {
            listener.onFailure(new MasterNotDiscoveredException());
            return;
        }
        AllocateDangledRequest request = new AllocateDangledRequest(this.clusterService.localNode(), indices.toArray(new IndexMetadata[indices.size()]));
        this.transportService.sendRequest(masterNode, ACTION_NAME, request, new ActionListenerResponseHandler<AllocateDangledResponse>(listener, AllocateDangledResponse::new, "same"));
    }

    class AllocateDangledRequestHandler
    implements TransportRequestHandler<AllocateDangledRequest> {
        AllocateDangledRequestHandler() {
        }

        @Override
        public void messageReceived(final AllocateDangledRequest request, final TransportChannel channel) throws Exception {
            Object[] indexNames = new String[request.indices.length];
            for (int i = 0; i < request.indices.length; ++i) {
                indexNames[i] = request.indices[i].getIndex().getName();
            }
            LocalAllocateDangledIndices.this.clusterService.submitStateUpdateTask("allocation dangled indices " + Arrays.toString(indexNames), new ClusterStateUpdateTask(this){
                final /* synthetic */ AllocateDangledRequestHandler this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public ClusterState execute(ClusterState currentState) {
                    if (currentState.blocks().disableStatePersistence()) {
                        return currentState;
                    }
                    Metadata.Builder metadata = Metadata.builder(currentState.metadata());
                    ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                    RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
                    Version minIndexCompatibilityVersion = currentState.nodes().getMaxNodeVersion().minimumIndexCompatibilityVersion();
                    boolean importNeeded = false;
                    StringBuilder sb = new StringBuilder();
                    for (IndexMetadata indexMetadata : request.indices) {
                        IndexMetadata upgradedIndexMetadata;
                        if (indexMetadata.getCreationVersion().before(minIndexCompatibilityVersion)) {
                            LOGGER.warn("ignoring dangled index [{}] on node [{}] since it's created version [{}] is not supported by at least one node in the cluster minVersion [{}]", (Object)indexMetadata.getIndex(), (Object)request.fromNode, (Object)indexMetadata.getCreationVersion(), (Object)minIndexCompatibilityVersion);
                            continue;
                        }
                        if (currentState.metadata().hasIndex(indexMetadata.getIndex())) continue;
                        if (currentState.metadata().hasAlias(indexMetadata.getIndex().getName())) {
                            LOGGER.warn("ignoring dangled index [{}] on node [{}] due to an existing alias with the same name", (Object)indexMetadata.getIndex(), (Object)request.fromNode);
                            continue;
                        }
                        importNeeded = true;
                        try {
                            String indexName = indexMetadata.getIndex().getName();
                            upgradedIndexMetadata = this.this$1.LocalAllocateDangledIndices.this.metadataIndexUpgradeService.upgradeIndexMetadata(indexMetadata, IndexName.isPartitioned(indexName) ? currentState.metadata().templates().get(PartitionName.templateName(indexName)) : null, minIndexCompatibilityVersion, null);
                            upgradedIndexMetadata = IndexMetadata.builder(upgradedIndexMetadata).settings(Settings.builder().put(upgradedIndexMetadata.getSettings()).put("index.history.uuid", UUIDs.randomBase64UUID())).build();
                        }
                        catch (Exception ex) {
                            LOGGER.warn(() -> new ParameterizedMessage("found dangled index [{}] on node [{}]. This index cannot be upgraded to the latest version, adding as closed", (Object)indexMetadata.getIndex(), (Object)request2.fromNode), (Throwable)ex);
                            upgradedIndexMetadata = IndexMetadata.builder(indexMetadata).state(IndexMetadata.State.CLOSE).version(indexMetadata.getVersion() + 1L).build();
                        }
                        metadata.put(upgradedIndexMetadata, false);
                        blocks.addBlocks(upgradedIndexMetadata);
                        if (upgradedIndexMetadata.getState() == IndexMetadata.State.OPEN || IndexMetadata.isIndexVerifiedBeforeClosed(indexMetadata)) {
                            routingTableBuilder.addAsFromDangling(upgradedIndexMetadata);
                        }
                        sb.append("[").append(upgradedIndexMetadata.getIndex()).append("/").append((Object)upgradedIndexMetadata.getState()).append("]");
                    }
                    if (!importNeeded) {
                        return currentState;
                    }
                    LOGGER.info("auto importing dangled indices {} from [{}]", (Object)sb.toString(), (Object)request.fromNode);
                    RoutingTable routingTable = routingTableBuilder.build();
                    ClusterState updatedState = ClusterState.builder(currentState).metadata(metadata).blocks(blocks).routingTable(routingTable).build();
                    return this.this$1.LocalAllocateDangledIndices.this.allocationService.reroute(ClusterState.builder(updatedState).routingTable(routingTable).build(), "dangling indices allocated");
                }

                @Override
                public void onFailure(String source, Exception e) {
                    LOGGER.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception inner) {
                        inner.addSuppressed(e);
                        LOGGER.warn("failed send response for allocating dangled", (Throwable)inner);
                    }
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    try {
                        channel.sendResponse(new AllocateDangledResponse(true));
                    }
                    catch (IOException e) {
                        LOGGER.warn("failed send response for allocating dangled", (Throwable)e);
                    }
                }
            });
        }
    }

    public static class AllocateDangledRequest
    extends TransportRequest {
        final DiscoveryNode fromNode;
        final IndexMetadata[] indices;

        AllocateDangledRequest(DiscoveryNode fromNode, IndexMetadata[] indices) {
            this.fromNode = fromNode;
            this.indices = indices;
        }

        public AllocateDangledRequest(StreamInput in) throws IOException {
            super(in);
            this.fromNode = new DiscoveryNode(in);
            this.indices = in.readArray(IndexMetadata::readFrom, IndexMetadata[]::new);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.fromNode.writeTo(out);
            out.writeArray(this.indices);
        }
    }

    public static class AllocateDangledResponse
    extends TransportResponse {
        private final boolean ack;

        AllocateDangledResponse(boolean ack) {
            this.ack = ack;
        }

        public AllocateDangledResponse(StreamInput in) throws IOException {
            this.ack = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.ack);
        }
    }
}

