/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import io.crate.types.DataTypes;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.IndexSettings;

public final class MergeSchedulerConfig {
    public static final Setting<Integer> MAX_THREAD_COUNT_SETTING = new Setting<Integer>("index.merge.scheduler.max_thread_count", s -> Integer.toString(Math.max(1, Math.min(4, EsExecutors.numberOfProcessors(s) / 2))), s -> Setting.parseInt(s, 1, "index.merge.scheduler.max_thread_count"), DataTypes.INTEGER, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.ReplicatedIndexScope);
    public static final Setting<Integer> MAX_MERGE_COUNT_SETTING = new Setting<Integer>("index.merge.scheduler.max_merge_count", s -> Integer.toString(MAX_THREAD_COUNT_SETTING.get((Settings)s) + 5), s -> Setting.parseInt(s, 1, "index.merge.scheduler.max_merge_count"), DataTypes.INTEGER, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> AUTO_THROTTLE_SETTING = Setting.boolSetting("index.merge.scheduler.auto_throttle", true, Setting.Property.Dynamic, Setting.Property.IndexScope);
    private volatile boolean autoThrottle;
    private volatile int maxThreadCount;
    private volatile int maxMergeCount;

    MergeSchedulerConfig(IndexSettings indexSettings) {
        int maxThread = indexSettings.getValue(MAX_THREAD_COUNT_SETTING);
        int maxMerge = indexSettings.getValue(MAX_MERGE_COUNT_SETTING);
        this.setMaxThreadAndMergeCount(maxThread, maxMerge);
        this.autoThrottle = indexSettings.getValue(AUTO_THROTTLE_SETTING);
    }

    public boolean isAutoThrottle() {
        return this.autoThrottle;
    }

    void setAutoThrottle(boolean autoThrottle) {
        this.autoThrottle = autoThrottle;
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    void setMaxThreadAndMergeCount(int maxThreadCount, int maxMergeCount) {
        if (maxThreadCount < 1) {
            throw new IllegalArgumentException("maxThreadCount should be at least 1");
        }
        if (maxMergeCount < 1) {
            throw new IllegalArgumentException("maxMergeCount should be at least 1");
        }
        if (maxThreadCount > maxMergeCount) {
            throw new IllegalArgumentException("maxThreadCount (= " + maxThreadCount + ") should be <= maxMergeCount (= " + maxMergeCount + ")");
        }
        this.maxThreadCount = maxThreadCount;
        this.maxMergeCount = maxMergeCount;
    }

    public int getMaxMergeCount() {
        return this.maxMergeCount;
    }
}

