/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import io.crate.common.io.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;

public final class IndexAnalyzers
extends AbstractIndexComponent
implements Closeable {
    private final NamedAnalyzer defaultIndexAnalyzer;
    private final Map<String, NamedAnalyzer> analyzers;
    private final Map<String, NamedAnalyzer> normalizers;
    private final Map<String, NamedAnalyzer> whitespaceNormalizers;

    public IndexAnalyzers(IndexSettings indexSettings, NamedAnalyzer defaultIndexAnalyzer, Map<String, NamedAnalyzer> analyzers, Map<String, NamedAnalyzer> normalizers, Map<String, NamedAnalyzer> whitespaceNormalizers) {
        super(indexSettings);
        this.defaultIndexAnalyzer = defaultIndexAnalyzer;
        this.analyzers = Collections.unmodifiableMap(analyzers);
        this.normalizers = Collections.unmodifiableMap(normalizers);
        this.whitespaceNormalizers = Collections.unmodifiableMap(whitespaceNormalizers);
    }

    public NamedAnalyzer get(String name) {
        return this.analyzers.get(name);
    }

    public NamedAnalyzer getNormalizer(String name) {
        return this.normalizers.get(name);
    }

    public NamedAnalyzer getWhitespaceNormalizer(String name) {
        return this.whitespaceNormalizers.get(name);
    }

    public NamedAnalyzer getDefaultIndexAnalyzer() {
        return this.defaultIndexAnalyzer;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{() -> Stream.concat(this.analyzers.values().stream(), this.normalizers.values().stream()).filter(a -> a.scope() == AnalyzerScope.INDEX).iterator()});
    }
}

