/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.FilterCodecReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.OneMergeWrappingMergePolicy;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

final class PrunePostingsMergePolicy
extends OneMergeWrappingMergePolicy {
    PrunePostingsMergePolicy(MergePolicy in, String idField) {
        super(in, toWrap -> new MergePolicy.OneMerge(toWrap.segments, (MergePolicy.OneMerge)toWrap, idField){
            final /* synthetic */ MergePolicy.OneMerge val$toWrap;
            final /* synthetic */ String val$idField;
            {
                this.val$toWrap = oneMerge;
                this.val$idField = string;
                super(segments);
            }

            public CodecReader wrapForMerge(CodecReader reader) throws IOException {
                CodecReader wrapped = this.val$toWrap.wrapForMerge(reader);
                return PrunePostingsMergePolicy.wrapReader(wrapped, this.val$idField);
            }
        });
    }

    private static CodecReader wrapReader(CodecReader reader, final String idField) {
        final Bits liveDocs = reader.getLiveDocs();
        if (liveDocs == null) {
            return reader;
        }
        final boolean fullyDeletedSegment = reader.numDocs() == 0;
        return new FilterCodecReader(reader){

            public FieldsProducer getPostingsReader() {
                final FieldsProducer postingsReader = super.getPostingsReader();
                if (postingsReader == null) {
                    return null;
                }
                return new FieldsProducer(this){
                    final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void close() throws IOException {
                        postingsReader.close();
                    }

                    public void checkIntegrity() throws IOException {
                        postingsReader.checkIntegrity();
                    }

                    public Iterator<String> iterator() {
                        return postingsReader.iterator();
                    }

                    public Terms terms(String field) throws IOException {
                        Terms in = postingsReader.terms(field);
                        if (this.this$0.idField.equals(field) && in != null) {
                            return new FilterLeafReader.FilterTerms(in){

                                public TermsEnum iterator() throws IOException {
                                    TermsEnum iterator = super.iterator();
                                    return new FilteredTermsEnum(iterator, false){
                                        private PostingsEnum internal;

                                        protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) throws IOException {
                                            if (this$0.fullyDeletedSegment) {
                                                return FilteredTermsEnum.AcceptStatus.END;
                                            }
                                            this.internal = this.postings(this.internal, 0);
                                            if (this.internal.nextDoc() != Integer.MAX_VALUE) {
                                                return FilteredTermsEnum.AcceptStatus.YES;
                                            }
                                            return FilteredTermsEnum.AcceptStatus.NO;
                                        }

                                        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
                                            if (reuse instanceof OnlyLiveDocsPostingsEnum) {
                                                OnlyLiveDocsPostingsEnum reuseInstance = (OnlyLiveDocsPostingsEnum)reuse;
                                                reuseInstance.reset(super.postings(reuseInstance.in, flags));
                                                return reuseInstance;
                                            }
                                            return new OnlyLiveDocsPostingsEnum(super.postings(null, flags), this$0.liveDocs);
                                        }

                                        public ImpactsEnum impacts(int flags) throws IOException {
                                            throw new UnsupportedOperationException();
                                        }
                                    };
                                }
                            };
                        }
                        return in;
                    }

                    public int size() {
                        return postingsReader.size();
                    }
                };
            }

            public IndexReader.CacheHelper getCoreCacheHelper() {
                return null;
            }

            public IndexReader.CacheHelper getReaderCacheHelper() {
                return null;
            }
        };
    }

    private static final class OnlyLiveDocsPostingsEnum
    extends PostingsEnum {
        private final Bits liveDocs;
        private PostingsEnum in;

        OnlyLiveDocsPostingsEnum(PostingsEnum in, Bits liveDocs) {
            this.liveDocs = liveDocs;
            this.reset(in);
        }

        void reset(PostingsEnum in) {
            this.in = in;
        }

        public int docID() {
            return this.in.docID();
        }

        public int nextDoc() throws IOException {
            int docId;
            while ((docId = this.in.nextDoc()) != Integer.MAX_VALUE && !this.liveDocs.get(docId)) {
            }
            return docId;
        }

        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        public long cost() {
            return this.in.cost();
        }

        public int freq() throws IOException {
            return this.in.freq();
        }

        public int nextPosition() throws IOException {
            return this.in.nextPosition();
        }

        public int startOffset() throws IOException {
            return this.in.startOffset();
        }

        public int endOffset() throws IOException {
            return this.in.endOffset();
        }

        public BytesRef getPayload() throws IOException {
            return this.in.getPayload();
        }
    }
}

