/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.OperationRouting;
import org.elasticsearch.index.mapper.Uid;

final class ShardSplittingQuery
extends Query {
    private final IndexMetadata indexMetadata;
    private final int shardId;

    ShardSplittingQuery(IndexMetadata indexMetadata, int shardId) {
        this.indexMetadata = indexMetadata;
        this.shardId = shardId;
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) {
        return new ConstantScoreWeight(this, this, boost){
            final /* synthetic */ ShardSplittingQuery this$0;
            {
                this.this$0 = this$0;
                super(query, score);
            }

            public String toString() {
                return "weight(delete docs query)";
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                LeafReader leafReader = context.reader();
                FixedBitSet bitSet = new FixedBitSet(leafReader.maxDoc());
                Predicate<BytesRef> includeInShard = ref -> {
                    int targetShardId = OperationRouting.generateShardId(this.this$0.indexMetadata, Uid.decodeId(ref.bytes, ref.offset, ref.length), null);
                    return this.this$0.shardId == targetShardId;
                };
                assert (!this.this$0.indexMetadata.isRoutingPartitionedIndex());
                ShardSplittingQuery.findSplitDocs("_id", includeInShard, leafReader, arg_0 -> ((FixedBitSet)bitSet).set(arg_0));
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, (DocIdSetIterator)new BitSetIterator((BitSet)bitSet, (long)bitSet.length()));
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }
        };
    }

    public void visit(QueryVisitor visitor) {
    }

    public String toString(String field) {
        return "shard_splitting_query";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ShardSplittingQuery that = (ShardSplittingQuery)((Object)o);
        if (this.shardId != that.shardId) {
            return false;
        }
        return this.indexMetadata.equals(that.indexMetadata);
    }

    public int hashCode() {
        int result = this.indexMetadata.hashCode();
        result = 31 * result + this.shardId;
        return this.classHash() ^ result;
    }

    private static void findSplitDocs(String idField, Predicate<BytesRef> includeInShard, LeafReader leafReader, IntConsumer consumer) throws IOException {
        BytesRef idTerm;
        Terms terms = leafReader.terms(idField);
        TermsEnum iterator = terms.iterator();
        PostingsEnum postingsEnum = null;
        while ((idTerm = iterator.next()) != null) {
            int doc;
            if (includeInShard.test(idTerm)) continue;
            postingsEnum = iterator.postings(postingsEnum);
            while ((doc = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                consumer.accept(doc);
            }
        }
    }
}

