/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.snapshots.blobstore;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.jetbrains.annotations.Nullable;

public class SnapshotFiles
implements Writeable {
    private final String snapshot;
    private final List<BlobStoreIndexShardSnapshot.FileInfo> indexFiles;
    @Nullable
    private final String shardStateIdentifier;
    private Map<String, BlobStoreIndexShardSnapshot.FileInfo> physicalFiles = null;

    public String snapshot() {
        return this.snapshot;
    }

    public SnapshotFiles(String snapshot, List<BlobStoreIndexShardSnapshot.FileInfo> indexFiles, @Nullable String shardStateIdentifier) {
        this.snapshot = snapshot;
        this.indexFiles = indexFiles;
        this.shardStateIdentifier = shardStateIdentifier;
    }

    public SnapshotFiles(StreamInput in) throws IOException {
        this.snapshot = in.readString();
        this.indexFiles = in.readList(BlobStoreIndexShardSnapshot.FileInfo::new);
        this.shardStateIdentifier = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.snapshot);
        out.writeList(this.indexFiles);
        out.writeOptionalString(this.shardStateIdentifier);
    }

    @Nullable
    public String shardStateIdentifier() {
        return this.shardStateIdentifier;
    }

    public List<BlobStoreIndexShardSnapshot.FileInfo> indexFiles() {
        return this.indexFiles;
    }

    public boolean containPhysicalIndexFile(String physicalName) {
        return this.findPhysicalIndexFile(physicalName) != null;
    }

    private BlobStoreIndexShardSnapshot.FileInfo findPhysicalIndexFile(String physicalName) {
        if (this.physicalFiles == null) {
            HashMap<String, BlobStoreIndexShardSnapshot.FileInfo> files = new HashMap<String, BlobStoreIndexShardSnapshot.FileInfo>();
            for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : this.indexFiles) {
                files.put(fileInfo.physicalName(), fileInfo);
            }
            this.physicalFiles = files;
        }
        return this.physicalFiles.get(physicalName);
    }
}

