/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import io.crate.action.FutureActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.seqno.LocalCheckpointTracker;
import org.jetbrains.annotations.Nullable;

public class RecoveryRequestTracker {
    private final Map<Long, FutureActionListener<Void>> ongoingRequests = Collections.synchronizedMap(new HashMap());
    private final LocalCheckpointTracker checkpointTracker = new LocalCheckpointTracker(-1L, -1L);

    @Nullable
    public synchronized ActionListener<Void> markReceivedAndCreateListener(final long requestSeqNo, final ActionListener<Void> listener) {
        if (this.checkpointTracker.hasProcessed(requestSeqNo)) {
            FutureActionListener<Void> existingFuture = this.ongoingRequests.get(requestSeqNo);
            if (existingFuture != null) {
                existingFuture.whenCompleteAsync(listener, EsExecutors.directExecutor());
            } else {
                listener.onResponse(null);
            }
            return null;
        }
        this.checkpointTracker.markSeqNoAsProcessed(requestSeqNo);
        FutureActionListener<Void> future = new FutureActionListener<Void>();
        this.ongoingRequests.put(requestSeqNo, future);
        future.whenCompleteAsync(new ActionListener<Void>(){
            final /* synthetic */ RecoveryRequestTracker this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResponse(Void v) {
                this.this$0.ongoingRequests.remove(requestSeqNo);
                listener.onResponse(v);
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, EsExecutors.directExecutor());
        return future;
    }
}

