/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class CompositeClassLoader
extends ClassLoader {
    private final List<ClassLoader> loaders;

    public CompositeClassLoader(ClassLoader parent, List<ClassLoader> loaders) {
        super(parent);
        this.loaders = Collections.unmodifiableList(loaders);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader loader : this.loaders) {
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList urls = new ArrayList();
        super.getResources(name).asIterator().forEachRemaining(urls::add);
        for (ClassLoader loader : this.loaders) {
            Enumeration<URL> resources = loader.getResources(name);
            resources.asIterator().forEachRemaining(urls::add);
        }
        return Collections.enumeration(urls);
    }
}

