/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import io.crate.action.FutureActionListener;
import io.crate.common.collections.Lists;
import io.crate.common.io.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.admin.cluster.repositories.delete.DeleteRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.repositories.VerifyNodeRepositoryAction;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class RepositoriesService
extends AbstractLifecycleComponent
implements ClusterStateApplier {
    private static final Logger LOGGER = LogManager.getLogger(RepositoriesService.class);
    private final Map<String, Repository.Factory> typesRegistry;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final VerifyNodeRepositoryAction verifyAction;
    private final Map<String, Repository> internalRepositories = new ConcurrentHashMap<String, Repository>();
    private volatile Map<String, Repository> repositories = Collections.emptyMap();

    public RepositoriesService(Settings settings, ClusterService clusterService, TransportService transportService, Map<String, Repository.Factory> typesRegistry, ThreadPool threadPool) {
        this.typesRegistry = typesRegistry;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        if ((DiscoveryNode.isDataNode(settings) || DiscoveryNode.isMasterEligibleNode(settings)) && !RepositoriesService.isDedicatedVotingOnlyNode(DiscoveryNode.getRolesFromSettings(settings))) {
            clusterService.addHighPriorityApplier(this);
        }
        this.verifyAction = new VerifyNodeRepositoryAction(transportService, clusterService, this);
    }

    public CompletableFuture<ClusterStateUpdateResponse> registerRepository(final PutRepositoryRequest request) {
        assert (this.lifecycle.started()) : "Trying to register new repository but service is in state [" + String.valueOf((Object)this.lifecycle.state()) + "]";
        final RepositoryMetadata newRepositoryMetadata = new RepositoryMetadata(request.name(), request.type(), request.settings());
        AckedClusterStateUpdateTask<ClusterStateUpdateResponse> updateTask = new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(this, (AckedRequest)request){
            final /* synthetic */ RepositoriesService this$0;
            {
                this.this$0 = this$0;
                super(request2);
            }

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws IOException {
                this.this$0.ensureRepositoryNotInUse(currentState, request.name());
                if (!this.this$0.registerRepository(newRepositoryMetadata)) {
                    return currentState;
                }
                Metadata metadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
                RepositoriesMetadata repositories = (RepositoriesMetadata)metadata.custom("repositories");
                if (repositories == null) {
                    LOGGER.info("put repository [{}]", (Object)request.name());
                    repositories = new RepositoriesMetadata(Collections.singletonList(new RepositoryMetadata(request.name(), request.type(), request.settings())));
                } else {
                    boolean found = false;
                    ArrayList<RepositoryMetadata> repositoriesMetadata = new ArrayList<RepositoryMetadata>(repositories.repositories().size() + 1);
                    for (RepositoryMetadata repositoryMetadata : repositories.repositories()) {
                        if (repositoryMetadata.name().equals(newRepositoryMetadata.name())) {
                            if (newRepositoryMetadata.equalsIgnoreGenerations(repositoryMetadata)) {
                                return currentState;
                            }
                            found = true;
                            repositoriesMetadata.add(newRepositoryMetadata);
                            continue;
                        }
                        repositoriesMetadata.add(repositoryMetadata);
                    }
                    if (!found) {
                        LOGGER.info("put repository [{}]", (Object)request.name());
                        repositoriesMetadata.add(new RepositoryMetadata(request.name(), request.type(), request.settings()));
                    } else {
                        LOGGER.info("update repository [{}]", (Object)request.name());
                    }
                    repositories = new RepositoriesMetadata(repositoriesMetadata);
                }
                mdBuilder.putCustom("repositories", repositories);
                return ClusterState.builder(currentState).metadata(mdBuilder).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                LOGGER.warn(() -> new ParameterizedMessage("failed to create repository [{}]", (Object)request.name()), (Throwable)e);
                super.onFailure(source, e);
            }

            @Override
            public boolean mustAck(DiscoveryNode discoveryNode) {
                return discoveryNode.isMasterEligibleNode() || discoveryNode.isDataNode();
            }
        };
        this.clusterService.submitStateUpdateTask("put_repository [" + request.name() + "]", updateTask);
        if (request.verify()) {
            return updateTask.completionFuture().thenCompose(response -> {
                if (response.isAcknowledged()) {
                    FutureActionListener<List<DiscoveryNode>> listener = new FutureActionListener<List<DiscoveryNode>>();
                    this.verifyRepository(request.name(), listener);
                    return listener.thenApply(ignored -> response);
                }
                return CompletableFuture.completedFuture(response);
            });
        }
        return updateTask.completionFuture();
    }

    public CompletableFuture<ClusterStateUpdateResponse> unregisterRepository(final DeleteRepositoryRequest request) {
        AckedClusterStateUpdateTask<ClusterStateUpdateResponse> updateTask = new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(this, (AckedRequest)request){
            final /* synthetic */ RepositoriesService this$0;
            {
                this.this$0 = this$0;
                super(request2);
            }

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                Metadata metadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
                RepositoriesMetadata repositories = (RepositoriesMetadata)metadata.custom("repositories");
                if (repositories != null && repositories.repositories().size() > 0) {
                    ArrayList<RepositoryMetadata> repositoriesMetadata = new ArrayList<RepositoryMetadata>(repositories.repositories().size());
                    boolean changed = false;
                    for (RepositoryMetadata repositoryMetadata : repositories.repositories()) {
                        if (Regex.simpleMatch(request.name(), repositoryMetadata.name())) {
                            this.this$0.ensureRepositoryNotInUse(currentState, request.name());
                            LOGGER.info("delete repository [{}]", (Object)repositoryMetadata.name());
                            changed = true;
                            continue;
                        }
                        repositoriesMetadata.add(repositoryMetadata);
                    }
                    if (changed) {
                        repositories = new RepositoriesMetadata(repositoriesMetadata);
                        mdBuilder.putCustom("repositories", repositories);
                        return ClusterState.builder(currentState).metadata(mdBuilder).build();
                    }
                }
                if (Regex.isMatchAllPattern(request.name())) {
                    return currentState;
                }
                throw new RepositoryMissingException(request.name());
            }

            @Override
            public boolean mustAck(DiscoveryNode discoveryNode) {
                return discoveryNode.isMasterEligibleNode() || discoveryNode.isDataNode();
            }
        };
        this.clusterService.submitStateUpdateTask("delete_repository [" + request.name() + "]", updateTask);
        return updateTask.completionFuture();
    }

    public void verifyRepository(final String repositoryName, ActionListener<List<DiscoveryNode>> listener) {
        final Repository repository = this.repository(repositoryName);
        final boolean readOnly = repository.isReadOnly();
        this.threadPool.executor("snapshot").execute(new ActionRunnable<List<DiscoveryNode>>(this, listener){
            final /* synthetic */ RepositoriesService this$0;
            {
                this.this$0 = this$0;
                super(listener);
            }

            @Override
            protected void doRun() {
                String verificationToken = repository.startVerification();
                if (verificationToken != null) {
                    try {
                        this.this$0.verifyAction.verify(repositoryName, readOnly, verificationToken, ActionListener.delegateFailure(this.listener, (delegatedListener, verifyResponse) -> this.this$0.threadPool.executor("snapshot").execute(() -> {
                            try {
                                repository.endVerification(verificationToken);
                            }
                            catch (Exception e) {
                                LOGGER.warn(() -> new ParameterizedMessage("[{}] failed to finish repository verification", (Object)repositoryName), (Throwable)e);
                                delegatedListener.onFailure(e);
                                return;
                            }
                            delegatedListener.onResponse(verifyResponse);
                        })));
                    }
                    catch (Exception e) {
                        this.this$0.threadPool.executor("snapshot").execute(() -> {
                            try {
                                repository.endVerification(verificationToken);
                            }
                            catch (Exception inner) {
                                inner.addSuppressed(e);
                                LOGGER.warn(() -> new ParameterizedMessage("[{}] failed to finish repository verification", (Object)repositoryName), (Throwable)inner);
                            }
                            this.listener.onFailure(e);
                        });
                    }
                } else {
                    this.listener.onResponse(Collections.emptyList());
                }
            }
        });
    }

    static boolean isDedicatedVotingOnlyNode(Set<DiscoveryNodeRole> roles) {
        return roles.contains(DiscoveryNodeRole.MASTER_ROLE) && !roles.contains(DiscoveryNodeRole.DATA_ROLE) && roles.stream().anyMatch(role -> role.roleName().equals("voting_only"));
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        try {
            ClusterState state = event.state();
            RepositoriesMetadata oldMetadata = (RepositoriesMetadata)event.previousState().metadata().custom("repositories");
            RepositoriesMetadata newMetadata = (RepositoriesMetadata)state.metadata().custom("repositories");
            if (oldMetadata == null && newMetadata == null || oldMetadata != null && oldMetadata.equalsIgnoreGenerations(newMetadata)) {
                for (Repository repo : this.repositories.values()) {
                    repo.updateState(state);
                }
                return;
            }
            LOGGER.trace("processing new index repositories for state version [{}]", (Object)event.state().version());
            HashMap<String, Repository> survivors = new HashMap<String, Repository>();
            for (Map.Entry<String, Repository> entry : this.repositories.entrySet()) {
                if (newMetadata == null || newMetadata.repository(entry.getKey()) == null) {
                    LOGGER.debug("unregistering repository [{}]", (Object)entry.getKey());
                    this.closeRepository(entry.getValue());
                    continue;
                }
                survivors.put(entry.getKey(), entry.getValue());
            }
            HashMap<String, Repository> builder = new HashMap<String, Repository>();
            if (newMetadata != null) {
                for (RepositoryMetadata repositoryMetadata : newMetadata.repositories()) {
                    Repository repository = (Repository)survivors.get(repositoryMetadata.name());
                    if (repository != null) {
                        RepositoryMetadata previousMetadata = repository.getMetadata();
                        if (!previousMetadata.type().equals(repositoryMetadata.type()) || !previousMetadata.settings().equals(repositoryMetadata.settings())) {
                            LOGGER.debug("updating repository [{}]", (Object)repositoryMetadata.name());
                            this.closeRepository(repository);
                            repository = null;
                            try {
                                repository = this.createRepository(repositoryMetadata);
                            }
                            catch (RepositoryException ex) {
                                LOGGER.warn(() -> new ParameterizedMessage("failed to change repository [{}]", (Object)repositoryMetadata.name()), (Throwable)ex);
                            }
                        }
                    } else {
                        try {
                            repository = this.createRepository(repositoryMetadata);
                        }
                        catch (RepositoryException ex) {
                            LOGGER.warn(() -> new ParameterizedMessage("failed to create repository [{}]", (Object)repositoryMetadata.name()), (Throwable)ex);
                        }
                    }
                    if (repository == null) continue;
                    LOGGER.debug("registering repository [{}]", (Object)repositoryMetadata.name());
                    builder.put(repositoryMetadata.name(), repository);
                }
            }
            for (Repository repo : builder.values()) {
                repo.updateState(state);
            }
            this.repositories = Collections.unmodifiableMap(builder);
        }
        catch (Exception ex) {
            assert (false) : new AssertionError((Object)ex);
            LOGGER.warn("failure updating cluster state ", (Throwable)ex);
        }
    }

    public CompletableFuture<RepositoryData> getRepositoryData(String repositoryName) {
        try {
            Repository repository = this.repository(repositoryName);
            return repository.getRepositoryData();
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public Repository repository(String repositoryName) {
        Repository repository = this.repositories.get(repositoryName);
        if (repository != null) {
            return repository;
        }
        repository = this.internalRepositories.get(repositoryName);
        if (repository != null) {
            return repository;
        }
        throw new RepositoryMissingException(repositoryName);
    }

    private boolean registerRepository(RepositoryMetadata repositoryMetadata) throws IOException {
        RepositoryMetadata previousMetadata;
        Repository previous = this.repositories.get(repositoryMetadata.name());
        if (previous != null && (previousMetadata = previous.getMetadata()).equals(repositoryMetadata)) {
            return false;
        }
        Repository newRepo = this.createRepository(repositoryMetadata);
        if (previous != null) {
            this.closeRepository(previous);
        }
        HashMap<String, Repository> newRepositories = new HashMap<String, Repository>(this.repositories);
        newRepositories.put(repositoryMetadata.name(), newRepo);
        this.repositories = newRepositories;
        return true;
    }

    public void registerInternalRepository(String name, String type) {
        RepositoryMetadata metadata = new RepositoryMetadata(name, type, Settings.EMPTY);
        Repository repository = this.internalRepositories.computeIfAbsent(name, n -> {
            LOGGER.debug("put internal repository [{}][{}]", (Object)name, (Object)type);
            return this.createRepository(metadata);
        });
        if (!type.equals(repository.getMetadata().type())) {
            LOGGER.warn((Message)new ParameterizedMessage("internal repository [{}][{}] already registered. this prevented the registration of internal repository [{}][{}].", new Object[]{name, repository.getMetadata().type(), name, type}));
        } else if (this.repositories.containsKey(name)) {
            LOGGER.warn((Message)new ParameterizedMessage("non-internal repository [{}] already registered. this repository will block the usage of internal repository [{}][{}].", new Object[]{name, metadata.type(), name}));
        }
    }

    public void unregisterInternalRepository(String name) {
        Repository repository = this.internalRepositories.remove(name);
        if (repository != null) {
            RepositoryMetadata metadata = repository.getMetadata();
            LOGGER.debug(() -> new ParameterizedMessage("delete internal repository [{}][{}].", (Object)metadata.type(), (Object)name));
            this.closeRepository(repository);
        }
    }

    private void closeRepository(Repository repository) {
        LOGGER.debug("closing repository [{}][{}]", (Object)repository.getMetadata().type(), (Object)repository.getMetadata().name());
        repository.close();
    }

    private Repository createRepository(RepositoryMetadata repositoryMetadata) {
        LOGGER.debug("creating repository [{}][{}]", (Object)repositoryMetadata.type(), (Object)repositoryMetadata.name());
        Repository.Factory factory = this.typesRegistry.get(repositoryMetadata.type());
        if (factory == null) {
            throw new RepositoryException(repositoryMetadata.name(), "repository type [" + repositoryMetadata.type() + "] does not exist");
        }
        Repository repository = null;
        try {
            repository = factory.create(repositoryMetadata);
            repository.start();
            return repository;
        }
        catch (RepositoryException e) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{repository});
            throw e;
        }
        catch (Exception e) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{repository});
            LOGGER.warn((Message)new ParameterizedMessage("failed to create repository [{}][{}]", (Object)repositoryMetadata.type(), (Object)repositoryMetadata.name()), (Throwable)e);
            throw new RepositoryException(repositoryMetadata.name(), "failed to create repository", e);
        }
    }

    private void ensureRepositoryNotInUse(ClusterState clusterState, String repository) {
        if (RepositoriesService.isRepositoryInUse(clusterState, repository)) {
            throw new IllegalStateException("trying to modify or unregister repository that is currently used");
        }
    }

    public Collection<Repository> getRepositoriesList() {
        return Collections.unmodifiableCollection(this.repositories.values());
    }

    public Map<String, Repository.Factory> typesRegistry() {
        return this.typesRegistry;
    }

    private static boolean isRepositoryInUse(ClusterState clusterState, String repository) {
        SnapshotsInProgress snapshots = clusterState.custom("snapshots", SnapshotsInProgress.EMPTY);
        for (SnapshotsInProgress.Entry entry : snapshots.entries()) {
            if (!repository.equals(entry.snapshot().getRepository())) continue;
            return true;
        }
        for (SnapshotDeletionsInProgress.Entry entry : clusterState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY).getEntries()) {
            if (!entry.repository().equals(repository)) continue;
            return true;
        }
        for (RestoreInProgress.Entry entry : clusterState.custom("restore", RestoreInProgress.EMPTY)) {
            if (!repository.equals(entry.snapshot().getRepository())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() throws IOException {
        this.clusterService.removeApplier(this);
        IOUtils.close((Iterable)Lists.concat(this.internalRepositories.values(), this.repositories.values()));
    }
}

