/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.search.profile.Timer;
import org.elasticsearch.search.profile.query.QueryTimingType;

public final class QueryProfileBreakdown {
    private final Timer[] timings;
    private final QueryTimingType[] timingTypes = (QueryTimingType[])QueryTimingType.class.getEnumConstants();

    public QueryProfileBreakdown() {
        this.timings = new Timer[this.timingTypes.length];
        for (int i = 0; i < this.timings.length; ++i) {
            this.timings[i] = new Timer();
        }
    }

    public Timer getTimer(QueryTimingType timing) {
        return this.timings[timing.ordinal()];
    }

    public void setTimer(QueryTimingType timing, Timer timer) {
        this.timings[timing.ordinal()] = timer;
    }

    public Map<String, Long> toTimingMap() {
        HashMap<Object, Long> map = HashMap.newHashMap(this.timingTypes.length + 2);
        for (QueryTimingType timingType : this.timingTypes) {
            map.put(timingType.toString(), this.timings[timingType.ordinal()].getApproximateTiming());
            map.put(timingType.toString() + "_count", this.timings[timingType.ordinal()].getCount());
        }
        return Collections.unmodifiableMap(map);
    }
}

